@extends('layouts.app')

@section('title', 'Detalhes do Alerta')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <div class="flex items-center space-x-3 mb-2">
                    <h1 class="text-2xl font-bold text-gray-800">Detalhes do Alerta</h1>
                    <!-- Badge de Nível -->
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-{{ $alerta->getCorNivel() }}-100 text-{{ $alerta->getCorNivel() }}-800 border border-{{ $alerta->getCorNivel() }}-200">
                        @if($alerta->nivel == 'emergencia')
                            <i class="fas fa-skull-crossbones mr-1"></i>
                        @elseif($alerta->nivel == 'alerta')
                            <i class="fas fa-exclamation-triangle mr-1"></i>
                        @elseif($alerta->nivel == 'atencao')
                            <i class="fas fa-exclamation-circle mr-1"></i>
                        @else
                            <i class="fas fa-info-circle mr-1"></i>
                        @endif
                        {{ $alerta->getNivelFormatado() }}
                    </span>
                    
                    <!-- Badge de Estado -->
                    @if($alerta->isAtivo())
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-700 animate-pulse">
                            <i class="fas fa-circle mr-1 text-green-500"></i>
                            Ativo
                        </span>
                    @elseif($alerta->estado == 'resolvido')
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-700">
                            <i class="fas fa-check-circle mr-1"></i>
                            Resolvido
                        </span>
                    @else
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-gray-100 text-gray-700">
                            <i class="fas fa-times-circle mr-1"></i>
                            Cancelado
                        </span>
                    @endif
                </div>
                <p class="text-gray-600">{{ $alerta->getTipoFormatado() }} • {{ $alerta->created_at->format('d/m/Y H:i:s') }}</p>
            </div>
            <div class="flex space-x-3">
                @if($alerta->isAtivo())
                    <button onclick="openResolveModal({{ $alerta->id }}, '{{ $alerta->titulo }}')"
                            class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors">
                        <i class="fas fa-check mr-2"></i>
                        Resolver
                    </button>
                    <button onclick="openCancelModal({{ $alerta->id }}, '{{ $alerta->titulo }}')"
                            class="bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 transition-colors">
                        <i class="fas fa-times mr-2"></i>
                        Cancelar
                    </button>
                @endif
                <a href="{{ route('alertas.index') }}" 
                   class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 transition-colors">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Voltar
                </a>
            </div>
        </div>
    </div>

    <!-- Informações Principais -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Detalhes do Alerta -->
        <div class="lg:col-span-2 bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">
                <i class="fas fa-info-circle mr-2 text-blue-600"></i>
                Informações do Alerta
            </h3>
            
            <div class="space-y-6">
                <!-- Título e Descrição -->
                <div>
                    <h4 class="text-xl font-bold text-gray-900 mb-3">{{ $alerta->titulo }}</h4>
                    <p class="text-gray-700 leading-relaxed">{{ $alerta->descricao }}</p>
                </div>

                <!-- Valores Técnicos -->
                @if($alerta->valor_registado || $alerta->valor_limite)
                <div class="border-t pt-6">
                    <h5 class="font-semibold text-gray-900 mb-3">Valores Técnicos</h5>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @if($alerta->valor_registado)
                        <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm text-red-600 font-medium">Valor Registado</p>
                                    <p class="text-2xl font-bold text-red-700">{{ $alerta->valor_registado }}</p>
                                </div>
                                <i class="fas fa-thermometer-three-quarters text-3xl text-red-500"></i>
                            </div>
                        </div>
                        @endif
                        
                        @if($alerta->valor_limite)
                        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm text-yellow-600 font-medium">Limite de Segurança</p>
                                    <p class="text-2xl font-bold text-yellow-700">{{ $alerta->valor_limite }}</p>
                                </div>
                                <i class="fas fa-exclamation-triangle text-3xl text-yellow-500"></i>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
                @endif

                <!-- Ações Tomadas -->
                @if($alerta->acoes_tomadas)
                <div class="border-t pt-6">
                    <h5 class="font-semibold text-gray-900 mb-3">
                        @if($alerta->estado == 'resolvido')
                            <i class="fas fa-tools mr-2 text-green-600"></i>
                            Ações de Resolução
                        @else
                            <i class="fas fa-ban mr-2 text-red-600"></i>
                            Motivo do Cancelamento
                        @endif
                    </h5>
                    <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                        <p class="text-gray-700">{{ $alerta->acoes_tomadas }}</p>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Sidebar com Informações Contextuais -->
        <div class="space-y-6">
            <!-- Infraestrutura Afetada -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">
                    <i class="fas fa-{{ $alerta->barragem ? 'dam' : 'satellite-dish' }} mr-2 text-blue-600"></i>
                    Infraestrutura
                </h3>
                
                <div class="space-y-4">
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                        <div class="flex items-center justify-between mb-2">
                            <p class="text-sm text-blue-600 font-medium">Nome</p>
                            <i class="fas fa-{{ $alerta->barragem ? 'dam' : 'satellite-dish' }} text-blue-500"></i>
                        </div>
                        <p class="font-bold text-blue-800">{{ $alerta->getNomeInfrastrutura() }}</p>
                    </div>
                    
                    <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                        <p class="text-sm text-gray-600 mb-1">Tipo</p>
                        <p class="font-semibold text-gray-800">
                            {{ $alerta->barragem ? 'Barragem' : 'Estação Hidrométrica' }}
                        </p>
                    </div>
                    
                    @if($alerta->barragem || $alerta->estacao)
                    <a href="{{ $alerta->barragem ? route('barragens.show', $alerta->barragem) : route('estacoes.show', $alerta->estacao) }}" 
                       class="block w-full text-center bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                        <i class="fas fa-external-link-alt mr-2"></i>
                        Ver Detalhes
                    </a>
                    @endif
                </div>
            </div>

            <!-- Timeline do Alerta -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">
                    <i class="fas fa-clock mr-2 text-purple-600"></i>
                    Timeline
                </h3>
                
                <div class="space-y-4">
                    <!-- Criação -->
                    <div class="flex items-start space-x-3">
                        <div class="w-2 h-2 bg-red-500 rounded-full mt-2"></div>
                        <div>
                            <p class="text-sm font-medium text-gray-900">Alerta Criado</p>
                            <p class="text-xs text-gray-500">{{ $alerta->created_at->format('d/m/Y H:i:s') }}</p>
                            <p class="text-xs text-gray-600 mt-1">Sistema detectou condição anómala</p>
                        </div>
                    </div>
                    
                    <!-- Duração -->
                    <div class="flex items-start space-x-3">
                        <div class="w-2 h-2 bg-yellow-500 rounded-full mt-2"></div>
                        <div>
                            <p class="text-sm font-medium text-gray-900">Duração</p>
                            <p class="text-xs text-gray-600">{{ $alerta->getDuracaoFormatada() }}</p>
                        </div>
                    </div>
                    
                    <!-- Resolução/Cancelamento -->
                    @if($alerta->data_fim)
                    <div class="flex items-start space-x-3">
                        <div class="w-2 h-2 bg-{{ $alerta->estado == 'resolvido' ? 'green' : 'gray' }}-500 rounded-full mt-2"></div>
                        <div>
                            <p class="text-sm font-medium text-gray-900">
                                {{ $alerta->estado == 'resolvido' ? 'Resolvido' : 'Cancelado' }}
                            </p>
                            <p class="text-xs text-gray-500">{{ $alerta->data_fim->format('d/m/Y H:i:s') }}</p>
                        </div>
                    </div>
                    @else
                    <div class="flex items-start space-x-3">
                        <div class="w-2 h-2 bg-green-500 rounded-full mt-2 animate-pulse"></div>
                        <div>
                            <p class="text-sm font-medium text-green-700">Em Andamento</p>
                            <p class="text-xs text-green-600">Requer atenção</p>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Nível de Prioridade -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">
                    <i class="fas fa-flag mr-2 text-orange-600"></i>
                    Prioridade
                </h3>
                
                @php
                    $prioridade = 'Baixa';
                    $corPrioridade = 'green';
                    if ($alerta->nivel == 'emergencia') {
                        $prioridade = 'Crítica';
                        $corPrioridade = 'red';
                    } elseif ($alerta->nivel == 'alerta') {
                        $prioridade = 'Alta';
                        $corPrioridade = 'orange';
                    } elseif ($alerta->nivel == 'atencao') {
                        $prioridade = 'Média';
                        $corPrioridade = 'yellow';
                    }
                @endphp
                
                <div class="bg-{{ $corPrioridade }}-50 border border-{{ $corPrioridade }}-200 rounded-lg p-4 text-center">
                    <i class="fas fa-flag text-3xl text-{{ $corPrioridade }}-600 mb-2"></i>
                    <p class="font-bold text-{{ $corPrioridade }}-800">{{ $prioridade }}</p>
                    <p class="text-xs text-{{ $corPrioridade }}-600 mt-1">{{ $alerta->getNivelFormatado() }}</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para Resolução de Alerta -->
<div id="resolveModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex items-center mb-4">
                <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-green-100">
                    <i class="fas fa-check text-green-600 text-xl"></i>
                </div>
            </div>
            <div class="text-center">
                <h3 class="text-lg leading-6 font-medium text-gray-900 mb-2">Resolver Alerta</h3>
                <p class="text-sm text-gray-500 mb-4" id="resolveAlertTitle"></p>
                <form id="resolveForm" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Ações Tomadas</label>
                        <textarea name="acoes_tomadas" rows="4" required
                                  class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500"
                                  placeholder="Descreva as ações tomadas para resolver este alerta..."></textarea>
                    </div>
                    <div class="flex space-x-3">
                        <button type="submit" class="flex-1 bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors">
                            Resolver
                        </button>
                        <button type="button" onclick="closeModal('resolveModal')" class="flex-1 bg-gray-300 text-gray-700 px-4 py-2 rounded-md hover:bg-gray-400 transition-colors">
                            Cancelar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal para Cancelamento de Alerta -->
<div id="cancelModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex items-center mb-4">
                <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100">
                    <i class="fas fa-times text-red-600 text-xl"></i>
                </div>
            </div>
            <div class="text-center">
                <h3 class="text-lg leading-6 font-medium text-gray-900 mb-2">Cancelar Alerta</h3>
                <p class="text-sm text-gray-500 mb-4" id="cancelAlertTitle"></p>
                <form id="cancelForm" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Motivo do Cancelamento</label>
                        <textarea name="motivo" rows="4" required
                                  class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-red-500"
                                  placeholder="Explique por que este alerta deve ser cancelado..."></textarea>
                    </div>
                    <div class="flex space-x-3">
                        <button type="submit" class="flex-1 bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 transition-colors">
                            Cancelar Alerta
                        </button>
                        <button type="button" onclick="closeModal('cancelModal')" class="flex-1 bg-gray-300 text-gray-700 px-4 py-2 rounded-md hover:bg-gray-400 transition-colors">
                            Fechar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function openResolveModal(alertaId, titulo) {
    document.getElementById('resolveAlertTitle').textContent = titulo;
    document.getElementById('resolveForm').action = `/alertas/${alertaId}/resolve`;
    document.getElementById('resolveModal').classList.remove('hidden');
}

function openCancelModal(alertaId, titulo) {
    document.getElementById('cancelAlertTitle').textContent = titulo;
    document.getElementById('cancelForm').action = `/alertas/${alertaId}/cancel`;
    document.getElementById('cancelModal').classList.remove('hidden');
}

function closeModal(modalId) {
    document.getElementById(modalId).classList.add('hidden');
}

// Fechar modais ao clicar fora
window.onclick = function(event) {
    const resolveModal = document.getElementById('resolveModal');
    const cancelModal = document.getElementById('cancelModal');
    if (event.target == resolveModal) {
        resolveModal.classList.add('hidden');
    }
    if (event.target == cancelModal) {
        cancelModal.classList.add('hidden');
    }
}
</script>
@endsection