<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'Laravel') }} - Registro</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=poppins:300,400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            overflow: hidden;
        }

        .register-container {
            display: flex;
            min-height: 100vh;
        }

        .left-side {
            flex: 1;
            background: linear-gradient(45deg, #1e3c72, #2a5298, #3b82f6);
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }

        .left-side::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1.5" fill="white" opacity="0.08"/><circle cx="50" cy="10" r="0.8" fill="white" opacity="0.12"/><circle cx="10" cy="60" r="1.2" fill="white" opacity="0.06"/><circle cx="90" cy="30" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        }

        .welcome-content {
            text-align: center;
            color: white;
            z-index: 2;
            max-width: 500px;
            padding: 0 2rem;
        }

        .welcome-icon {
            width: 120px;
            height: 120px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 2rem;
            backdrop-filter: blur(10px);
            border: 2px solid rgba(255, 255, 255, 0.2);
            animation: float 3s ease-in-out infinite;
        }

        .welcome-icon i {
            font-size: 3rem;
            color: white;
        }

        .welcome-title {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 1rem;
            text-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
            letter-spacing: -1px;
        }

        .welcome-subtitle {
            font-size: 1.2rem;
            font-weight: 300;
            opacity: 0.9;
            line-height: 1.6;
            margin-bottom: 2rem;
        }

        .feature-list {
            list-style: none;
            text-align: left;
            max-width: 300px;
            margin: 0 auto;
        }

        .feature-list li {
            display: flex;
            align-items: center;
            margin-bottom: 1rem;
            font-size: 1rem;
            opacity: 0.9;
        }

        .feature-list i {
            margin-right: 0.75rem;
            width: 20px;
            color: #fbbf24;
        }

        .right-side {
            flex: 1;
            background: #f8fafc;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem;
            position: relative;
            overflow-y: auto;
        }

        .right-side::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100px;
            height: 100px;
            background: linear-gradient(45deg, #3b82f6, #1d4ed8);
            border-radius: 0 0 0 100px;
            opacity: 0.1;
        }

        .register-form-container {
            width: 100%;
            max-width: 450px;
            background: white;
            padding: 2.5rem;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            position: relative;
            border: 1px solid rgba(0, 0, 0, 0.05);
            margin: 2rem 0;
        }

        .form-header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .form-title {
            font-size: 2rem;
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 0.5rem;
        }

        .form-subtitle {
            color: #6b7280;
            font-size: 0.95rem;
            font-weight: 400;
        }

        .progress-steps {
            display: flex;
            justify-content: center;
            margin-bottom: 2rem;
        }

        .step {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: rgba(59, 130, 246, 0.2);
            margin: 0 4px;
            transition: all 0.3s ease;
        }

        .step.active {
            background: #3b82f6;
            transform: scale(1.2);
        }

        .step.completed {
            background: #10b981;
        }

        .input-wrapper {
            position: relative;
            margin-bottom: 1.25rem;
        }

        .input-label {
            display: block;
            font-size: 0.875rem;
            font-weight: 500;
            color: #374151;
            margin-bottom: 0.5rem;
        }

        .input-field {
            width: 100%;
            padding: 0.875rem;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            background: #fafafa;
            position: relative;
        }

        .input-field:focus {
            outline: none;
            border-color: #3b82f6;
            background: white;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }

        .input-field.valid {
            border-color: #10b981;
            background: rgba(240, 253, 244, 0.5);
        }

        .input-field.invalid {
            border-color: #ef4444;
            background: rgba(254, 242, 242, 0.5);
        }

        .validation-icon {
            position: absolute;
            right: 0.875rem;
            top: 50%;
            transform: translateY(-50%);
            font-size: 14px;
        }

        .valid-icon { color: #10b981; }
        .invalid-icon { color: #ef4444; }

        .password-toggle {
            position: absolute;
            right: 0.875rem;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #6b7280;
            cursor: pointer;
            padding: 0.25rem;
            border-radius: 4px;
            transition: color 0.3s ease;
            z-index: 10;
        }

        .password-toggle:hover {
            color: #3b82f6;
        }

        .password-strength {
            margin-top: 0.5rem;
        }

        .strength-bar {
            height: 4px;
            background: #e5e7eb;
            border-radius: 2px;
            overflow: hidden;
        }

        .strength-fill {
            height: 100%;
            transition: all 0.3s ease;
            border-radius: 2px;
        }

        .strength-weak { background: #ef4444; width: 25%; }
        .strength-fair { background: #f59e0b; width: 50%; }
        .strength-good { background: #10b981; width: 75%; }
        .strength-strong { background: #059669; width: 100%; }

        .register-button {
            width: 100%;
            background: linear-gradient(135deg, #3b82f6, #1d4ed8);
            color: white;
            border: none;
            padding: 0.875rem;
            border-radius: 12px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            margin-top: 1rem;
        }

        .register-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s ease;
        }

        .register-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(59, 130, 246, 0.3);
        }

        .register-button:hover::before {
            left: 100%;
        }

        .register-button:disabled {
            background: #9ca3af;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }

        .login-link {
            text-align: center;
            margin-top: 1.5rem;
            color: #6b7280;
            font-size: 0.875rem;
        }

        .login-link a {
            color: #3b82f6;
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s ease;
        }

        .login-link a:hover {
            color: #1d4ed8;
            text-decoration: underline;
        }

        .error-message {
            color: #ef4444;
            font-size: 0.75rem;
            margin-top: 0.25rem;
            display: flex;
            align-items: center;
        }

        .error-message i {
            margin-right: 0.25rem;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }

        @media (max-width: 768px) {
            .register-container {
                flex-direction: column;
            }

            .left-side {
                min-height: 30vh;
                padding: 1.5rem;
            }

            .welcome-title {
                font-size: 1.75rem;
            }

            .welcome-icon {
                width: 80px;
                height: 80px;
            }

            .welcome-icon i {
                font-size: 2rem;
            }

            .feature-list {
                display: none;
            }

            .register-form-container {
                padding: 2rem;
                margin: -1.5rem 1rem 1.5rem;
                border-radius: 20px 20px 0 0;
            }
        }
    </style>
</head>
<body>
    <div class="register-container">
        <!-- Left Side - Welcome Section -->
        <div class="left-side">
            <div class="welcome-content">
                <div class="welcome-icon">
                    <i class="fas fa-user-plus"></i>
                </div>
                <h1 class="welcome-title">Junte-se a Nós</h1>
                <p class="welcome-subtitle">
                    Crie sua conta e tenha acesso ao sistema de monitoramento
                </p>
                <ul class="feature-list">
                    <li><i class="fas fa-tachometer-alt"></i> Dashboard personalizado</li>
                    <li><i class="fas fa-chart-bar"></i> Relatórios detalhados</li>
                    <li><i class="fas fa-lock"></i> Acesso seguro</li>
                    <li><i class="fas fa-mobile-alt"></i> Acesso em qualquer lugar</li>
                </ul>
            </div>
        </div>

        <!-- Right Side - Register Form -->
        <div class="right-side">
            <div class="register-form-container">
                <div class="form-header">
                    <h2 class="form-title">Criar Conta</h2>
                    <p class="form-subtitle">Preencha os dados para se cadastrar</p>
                </div>

                <!-- Progress Steps -->
                <div class="progress-steps">
                    <div class="step active" id="step1"></div>
                    <div class="step" id="step2"></div>
                    <div class="step" id="step3"></div>
                    <div class="step" id="step4"></div>
                </div>

                <form method="POST" action="{{ route('register') }}">
                    @csrf

                    <!-- Name Field -->
                    <div class="input-wrapper">
                        <label for="name" class="input-label">Nome Completo</label>
                        <div style="position: relative;">
                            <input id="name"
                                   type="text"
                                   name="name"
                                   value="{{ old('name') }}"
                                   required
                                   autofocus
                                   autocomplete="name"
                                   placeholder="Digite seu nome completo"
                                   class="input-field {{ $errors->has('name') ? 'invalid' : '' }}"
                                   oninput="validateName()">
                            <i class="validation-icon fas" id="nameValidation"></i>
                        </div>
                        @error('name')
                            <div class="error-message">
                                <i class="fas fa-exclamation-circle"></i>{{ $message }}
                            </div>
                        @enderror
                    </div>

                    <!-- Email Field -->
                    <div class="input-wrapper">
                        <label for="email" class="input-label">Email</label>
                        <div style="position: relative;">
                            <input id="email"
                                   type="email"
                                   name="email"
                                   value="{{ old('email') }}"
                                   required
                                   autocomplete="username"
                                   placeholder="Digite seu email"
                                   class="input-field {{ $errors->has('email') ? 'invalid' : '' }}"
                                   oninput="validateEmail()">
                            <i class="validation-icon fas" id="emailValidation"></i>
                        </div>
                        @error('email')
                            <div class="error-message">
                                <i class="fas fa-exclamation-circle"></i>{{ $message }}
                            </div>
                        @enderror
                    </div>

                    <!-- Password Field -->
                    <div class="input-wrapper">
                        <label for="password" class="input-label">Senha</label>
                        <div style="position: relative;">
                            <input id="password"
                                   type="password"
                                   name="password"
                                   required
                                   autocomplete="new-password"
                                   placeholder="Digite sua senha"
                                   class="input-field {{ $errors->has('password') ? 'invalid' : '' }}"
                                   oninput="validatePassword()">
                            <button type="button" class="password-toggle" onclick="togglePassword('password', 'passwordToggle')">
                                <i id="passwordToggle" class="fas fa-eye"></i>
                            </button>
                        </div>
                        <div class="password-strength">
                            <div class="strength-bar">
                                <div class="strength-fill" id="strengthBar"></div>
                            </div>
                            <p class="text-xs mt-1 text-gray-600" id="strengthText">A senha deve ter pelo menos 8 caracteres</p>
                        </div>
                        @error('password')
                            <div class="error-message">
                                <i class="fas fa-exclamation-circle"></i>{{ $message }}
                            </div>
                        @enderror
                    </div>

                    <!-- Confirm Password Field -->
                    <div class="input-wrapper">
                        <label for="password_confirmation" class="input-label">Confirmar Senha</label>
                        <div style="position: relative;">
                            <input id="password_confirmation"
                                   type="password"
                                   name="password_confirmation"
                                   required
                                   autocomplete="new-password"
                                   placeholder="Confirme sua senha"
                                   class="input-field {{ $errors->has('password_confirmation') ? 'invalid' : '' }}"
                                   oninput="validatePasswordConfirmation()">
                            <button type="button" class="password-toggle" onclick="togglePassword('password_confirmation', 'confirmToggle')">
                                <i id="confirmToggle" class="fas fa-eye"></i>
                            </button>
                            <i class="validation-icon fas" id="confirmValidation" style="right: 2.5rem;"></i>
                        </div>
                        @error('password_confirmation')
                            <div class="error-message">
                                <i class="fas fa-exclamation-circle"></i>{{ $message }}
                            </div>
                        @enderror
                    </div>

                    <!-- Register Button -->
                    <button type="submit" id="submitBtn" class="register-button" disabled>
                        <i class="fas fa-user-plus" style="margin-right: 0.5rem;"></i>
                        Criar Conta
                    </button>
                </form>

                <!-- Login Link -->
                <div class="login-link">
                    Já tem uma conta?
                    <a href="{{ route('login') }}">Faça login aqui</a>
                </div>
            </div>
        </div>
    </div>

    <script>
        let validations = {
            name: false,
            email: false,
            password: false,
            passwordConfirmation: false
        };

        function updateProgressSteps() {
            const steps = ['step1', 'step2', 'step3', 'step4'];
            const validationKeys = ['name', 'email', 'password', 'passwordConfirmation'];

            validationKeys.forEach((key, index) => {
                const step = document.getElementById(steps[index]);
                if (validations[key]) {
                    step.classList.add('completed');
                    step.classList.remove('active');
                } else {
                    step.classList.remove('completed');
                    if (index === 0 || validations[validationKeys[index - 1]]) {
                        step.classList.add('active');
                    } else {
                        step.classList.remove('active');
                    }
                }
            });

            const submitBtn = document.getElementById('submitBtn');
            const allValid = Object.values(validations).every(v => v);
            submitBtn.disabled = !allValid;
        }

        function validateName() {
            const name = document.getElementById('name');
            const validation = document.getElementById('nameValidation');
            const isValid = name.value.trim().length >= 2;

            validations.name = isValid;

            if (name.value.length > 0) {
                if (isValid) {
                    name.classList.add('valid');
                    name.classList.remove('invalid');
                    validation.className = 'validation-icon fas fa-check valid-icon';
                } else {
                    name.classList.add('invalid');
                    name.classList.remove('valid');
                    validation.className = 'validation-icon fas fa-times invalid-icon';
                }
            } else {
                name.classList.remove('valid', 'invalid');
                validation.className = 'validation-icon fas';
            }

            updateProgressSteps();
        }

        function validateEmail() {
            const email = document.getElementById('email');
            const validation = document.getElementById('emailValidation');
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            const isValid = emailRegex.test(email.value);

            validations.email = isValid;

            if (email.value.length > 0) {
                if (isValid) {
                    email.classList.add('valid');
                    email.classList.remove('invalid');
                    validation.className = 'validation-icon fas fa-check valid-icon';
                } else {
                    email.classList.add('invalid');
                    email.classList.remove('valid');
                    validation.className = 'validation-icon fas fa-times invalid-icon';
                }
            } else {
                email.classList.remove('valid', 'invalid');
                validation.className = 'validation-icon fas';
            }

            updateProgressSteps();
        }

        function validatePassword() {
            const password = document.getElementById('password');
            const strengthBar = document.getElementById('strengthBar');
            const strengthText = document.getElementById('strengthText');

            const pwd = password.value;
            let strength = 0;
            let strengthLabel = '';

            if (pwd.length >= 8) strength++;
            if (/[a-z]/.test(pwd)) strength++;
            if (/[A-Z]/.test(pwd)) strength++;
            if (/[0-9]/.test(pwd)) strength++;
            if (/[^A-Za-z0-9]/.test(pwd)) strength++;

            const isValid = strength >= 3 && pwd.length >= 8;
            validations.password = isValid;

            if (pwd.length > 0) {
                switch (strength) {
                    case 0:
                    case 1:
                        strengthBar.className = 'strength-fill strength-weak';
                        strengthLabel = 'Muito fraca';
                        break;
                    case 2:
                        strengthBar.className = 'strength-fill strength-fair';
                        strengthLabel = 'Fraca';
                        break;
                    case 3:
                    case 4:
                        strengthBar.className = 'strength-fill strength-good';
                        strengthLabel = 'Boa';
                        break;
                    case 5:
                        strengthBar.className = 'strength-fill strength-strong';
                        strengthLabel = 'Muito forte';
                        break;
                }

                if (isValid) {
                    password.classList.add('valid');
                    password.classList.remove('invalid');
                } else {
                    password.classList.add('invalid');
                    password.classList.remove('valid');
                }

                strengthText.textContent = `Força da senha: ${strengthLabel}`;
            } else {
                password.classList.remove('valid', 'invalid');
                strengthBar.className = 'strength-fill';
                strengthText.textContent = 'A senha deve ter pelo menos 8 caracteres';
            }

            if (document.getElementById('password_confirmation').value) {
                validatePasswordConfirmation();
            }

            updateProgressSteps();
        }

        function validatePasswordConfirmation() {
            const password = document.getElementById('password');
            const confirmation = document.getElementById('password_confirmation');
            const validation = document.getElementById('confirmValidation');

            const isValid = confirmation.value === password.value && confirmation.value.length > 0;
            validations.passwordConfirmation = isValid;

            if (confirmation.value.length > 0) {
                if (isValid) {
                    confirmation.classList.add('valid');
                    confirmation.classList.remove('invalid');
                    validation.className = 'validation-icon fas fa-check valid-icon';
                } else {
                    confirmation.classList.add('invalid');
                    confirmation.classList.remove('valid');
                    validation.className = 'validation-icon fas fa-times invalid-icon';
                }
            } else {
                confirmation.classList.remove('valid', 'invalid');
                validation.className = 'validation-icon fas';
            }

            updateProgressSteps();
        }

        function togglePassword(inputId, toggleId) {
            const passwordInput = document.getElementById(inputId);
            const toggleIcon = document.getElementById(toggleId);

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                toggleIcon.classList.remove('fa-eye');
                toggleIcon.classList.add('fa-eye-slash');
            } else {
                passwordInput.type = 'password';
                toggleIcon.classList.remove('fa-eye-slash');
                toggleIcon.classList.add('fa-eye');
            }
        }

        // Add smooth focus animations
        document.querySelectorAll('.input-field').forEach(input => {
            input.addEventListener('focus', function() {
                this.style.transform = 'scale(1.02)';
            });

            input.addEventListener('blur', function() {
                this.style.transform = 'scale(1)';
            });
        });
    </script>
</body>
</html>
