@extends('layouts.app')

@section('title', 'Editar Leitura - ' . $barragem->nome)

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow">
        <!-- Breadcrumb -->
        <div class="px-6 py-3 border-b border-gray-200 bg-gray-50">
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-1 md:space-x-3">
                    <li class="inline-flex items-center">
                        <a href="{{ route('dashboard') }}" class="text-gray-500 hover:text-gray-700">
                            <i class="fas fa-home mr-1"></i>
                            Dashboard
                        </a>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('barragens.index') }}" class="text-gray-500 hover:text-gray-700">Barragens</a>
                        </div>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('barragens.show', $barragem) }}" class="text-gray-500 hover:text-gray-700">{{ $barragem->nome }}</a>
                        </div>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('barragens.leituras', $barragem) }}" class="text-gray-500 hover:text-gray-700">Leituras</a>
                        </div>
                    </li>
                    <li aria-current="page">
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <span class="text-gray-800 font-medium">Editar Leitura</span>
                        </div>
                    </li>
                </ol>
            </nav>
        </div>

        <!-- Header Principal -->
        <div class="px-6 py-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center mr-4">
                    <i class="fas fa-edit text-white text-xl"></i>
                </div>
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">Editar Leitura</h1>
                    <p class="text-gray-600">{{ $barragem->nome }} • {{ $leitura->data_leitura->format('d/m/Y') }} às {{ $leitura->hora_leitura ?? '06:00' }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Formulário -->
    <div class="bg-white rounded-lg shadow p-6">
        <form method="POST" action="{{ route('barragens.leituras.update', [$barragem, $leitura]) }}">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Dados Básicos -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900 flex items-center border-b pb-2">
                        <i class="fas fa-calendar-alt mr-2 text-blue-600"></i>
                        Dados Básicos
                    </h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Data da Leitura *</label>
                            <input type="date" name="data_leitura" required
                                   value="{{ old('data_leitura', $leitura->data_leitura->format('Y-m-d')) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            @error('data_leitura')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Hora da Leitura *</label>
                            <input type="time" name="hora_leitura" required
                                   value="{{ old('hora_leitura', $leitura->hora_leitura ?? '06:00') }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            @error('hora_leitura')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Cota Atual (m) *</label>
                            <input type="number" step="0.01" name="cota_actual" required
                                   value="{{ old('cota_actual', $leitura->cota_actual) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            @error('cota_actual')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Volume Atual (Mm³)</label>
                            <input type="number" step="0.01" name="volume_actual"
                                   value="{{ old('volume_actual', $leitura->volume_actual) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            @error('volume_actual')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Volume Morto (Mm³)</label>
                            <input type="number" step="0.01" name="volume_morto"
                                   value="{{ old('volume_morto', $leitura->volume_morto) }}"
                                   placeholder="Ex: 5.20"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            @error('volume_morto')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">% Total</label>
                            <input type="number" step="0.01" name="percentagem_total"
                                   value="{{ old('percentagem_total', $leitura->percentagem_total) }}"
                                   placeholder="Ex: 85.5"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            @error('percentagem_total')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Volume Armazenado (Mm³)</label>
                            <input type="number" step="0.01" name="volume_armazenado"
                                   value="{{ old('volume_armazenado', $leitura->volume_armazenado) }}"
                                   placeholder="Ex: 200.50"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            @error('volume_armazenado')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Captação FIPAG (m³/s)</label>
                            <input type="number" step="0.01" name="caudal_captacao"
                                   value="{{ old('caudal_captacao', $leitura->caudal_captacao) }}"
                                   placeholder="Ex: 2.30"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            @error('caudal_captacao')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Método de Leitura *</label>
                        <select name="metodo_leitura" required
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="manual" {{ old('metodo_leitura', $leitura->metodo_leitura) == 'manual' ? 'selected' : '' }}>Manual</option>
                            <option value="automatico" {{ old('metodo_leitura', $leitura->metodo_leitura) == 'automatico' ? 'selected' : '' }}>Automático</option>
                            <option value="telemetria" {{ old('metodo_leitura', $leitura->metodo_leitura) == 'telemetria' ? 'selected' : '' }}>Telemetria</option>
                        </select>
                        @error('metodo_leitura')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Caudais -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900 flex items-center border-b pb-2">
                        <i class="fas fa-water mr-2 text-cyan-600"></i>
                        Caudais (m³/s)
                    </h4>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Afluente</label>
                            <input type="number" step="0.01" name="caudal_afluente"
                                   value="{{ old('caudal_afluente', $leitura->caudal_afluente) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Efluente</label>
                            <input type="number" step="0.01" name="caudal_efluente"
                                   value="{{ old('caudal_efluente', $leitura->caudal_efluente) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Descarga de Fundo</label>
                            <input type="number" step="0.01" name="descarga_fundo"
                                   value="{{ old('descarga_fundo', $leitura->descarga_fundo) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Descarga de Superfície</label>
                            <input type="number" step="0.01" name="descarga_superficie"
                                   value="{{ old('descarga_superficie', $leitura->descarga_superficie) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Caudal Ecológico</label>
                            <input type="number" step="0.01" name="caudal_ecologico"
                                   value="{{ old('caudal_ecologico', $leitura->caudal_ecologico) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Caudal Turbinado</label>
                            <input type="number" step="0.01" name="caudal_turbinado"
                                   value="{{ old('caudal_turbinado', $leitura->caudal_turbinado) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Caudal Descarregador</label>
                            <input type="number" step="0.01" name="caudal_descarregador"
                                   value="{{ old('caudal_descarregador', $leitura->caudal_descarregador) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Evaporação</label>
                            <input type="number" step="0.01" name="evaporacao"
                                   value="{{ old('evaporacao', $leitura->evaporacao) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Infiltração</label>
                            <input type="number" step="0.01" name="infiltracao"
                                   value="{{ old('infiltracao', $leitura->infiltracao) }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dados Meteorológicos -->
            <div class="mt-6">
                <h4 class="font-medium text-gray-900 flex items-center border-b pb-2 mb-4">
                    <i class="fas fa-cloud-rain mr-2 text-blue-600"></i>
                    Dados Meteorológicos
                </h4>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Precipitação (mm)</label>
                    <input type="number" step="0.1" name="precipitacao"
                           value="{{ old('precipitacao', $leitura->precipitacao) }}"
                           placeholder="Ex: 12.5"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    @error('precipitacao')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Observações -->
            <div class="mt-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Observações</label>
                <textarea name="observacoes" rows="3"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">{{ old('observacoes', $leitura->observacoes) }}</textarea>
                @error('observacoes')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Botões -->
            <div class="flex justify-end space-x-4 mt-8">
                <a href="{{ route('barragens.leituras', $barragem) }}"
                   class="px-6 py-2 bg-gray-500 text-white rounded-md hover:bg-gray-600 transition-colors">
                    Cancelar
                </a>
                <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 transition-colors">
                    <i class="fas fa-save mr-2"></i>
                    Atualizar Leitura
                </button>
            </div>
        </form>
    </div>
</div>
@endsection