@extends('layouts.app')

@section('title', 'Leituras - ' . $barragem->nome)

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow">
        <!-- Breadcrumb -->
        <div class="px-6 py-3 border-b border-gray-200 bg-gray-50">
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-1 md:space-x-3">
                    <li class="inline-flex items-center">
                        <a href="{{ route('dashboard') }}" class="text-gray-500 hover:text-gray-700">
                            <i class="fas fa-home mr-1"></i>
                            Dashboard
                        </a>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('barragens.index') }}" class="text-gray-500 hover:text-gray-700">Barragens</a>
                        </div>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('barragens.show', $barragem) }}" class="text-gray-500 hover:text-gray-700">{{ $barragem->nome }}</a>
                        </div>
                    </li>
                    <li aria-current="page">
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <span class="text-gray-800 font-medium">Leituras</span>
                        </div>
                    </li>
                </ol>
            </nav>
        </div>

        <!-- Header Principal -->
        <div class="px-6 py-6">
            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                <div class="flex-1">
                    <div class="flex items-center mb-2">
                        <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-chart-line text-white text-xl"></i>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-900">Leituras Diárias</h1>
                            <p class="text-gray-600">{{ $barragem->nome }} ({{ $barragem->codigo }})</p>
                        </div>
                    </div>
                    
                    <div class="flex flex-wrap items-center gap-4 mt-3">
                        @php
                            $anoHidrologico = \App\Helpers\HydrologicalYear::getCurrentHydrologicalYear();
                            $estacaoAtual = \App\Helpers\HydrologicalYear::getCurrentSeason();
                        @endphp
                        
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-{{ $estacaoAtual['color'] }}-100 text-{{ $estacaoAtual['color'] }}-800 border border-{{ $estacaoAtual['color'] }}-200">
                            @if($estacaoAtual['season'] == 'chuvosa')
                                <i class="fas fa-cloud-rain mr-2"></i>
                            @else
                                <i class="fas fa-sun mr-2"></i>
                            @endif
                            {{ $estacaoAtual['label'] }} {{ $anoHidrologico }}/{{ $anoHidrologico + 1 }}
                        </span>
                        
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800 border border-blue-200">
                            <i class="fas fa-database mr-2"></i>
                            {{ $leituras->total() }} Leituras
                        </span>
                    </div>
                </div>

                <!-- Ações -->
                <div class="mt-6 lg:mt-0 lg:ml-6">
                    <div class="flex flex-col sm:flex-row gap-3">
                        <a href="#" onclick="toggleNovaLeitura()"
                           class="inline-flex items-center justify-center px-4 py-2 text-white rounded-lg transition-colors"
                           style="background-color: #16a34a; border: 1px solid #16a34a;"
                           onmouseover="this.style.backgroundColor='#15803d'"
                           onmouseout="this.style.backgroundColor='#16a34a'"
                           id="novaLeituraBtn">
                            <i class="fas fa-plus mr-2"></i>
                            Nova Leitura
                        </a>
                        <a href="#"
                           class="inline-flex items-center justify-center px-4 py-2 text-white rounded-lg transition-colors"
                           style="background-color: #2563eb; border: 1px solid #2563eb;"
                           onmouseover="this.style.backgroundColor='#1d4ed8'"
                           onmouseout="this.style.backgroundColor='#2563eb'">
                            <i class="fas fa-upload mr-2"></i>
                            Importar Excel
                        </a>
                        <a href="{{ route('barragens.show', $barragem) }}"
                           class="inline-flex items-center justify-center px-4 py-2 text-white rounded-lg transition-colors"
                           style="background-color: #4b5563; border: 1px solid #4b5563;"
                           onmouseover="this.style.backgroundColor='#374151'"
                           onmouseout="this.style.backgroundColor='#4b5563'">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Voltar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow p-6">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                <input type="date" name="data_inicio" value="{{ request('data_inicio') }}" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Fim</label>
                <input type="date" name="data_fim" value="{{ request('data_fim') }}" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Método</label>
                <select name="metodo" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    <option value="">Todos</option>
                    <option value="manual" {{ request('metodo') == 'manual' ? 'selected' : '' }}>Manual</option>
                    <option value="automatico" {{ request('metodo') == 'automatico' ? 'selected' : '' }}>Automático</option>
                    <option value="telemetria" {{ request('metodo') == 'telemetria' ? 'selected' : '' }}>Telemetria</option>
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit"
                        class="w-full text-white px-4 py-2 rounded-md transition-colors flex items-center justify-center"
                        style="background-color: #4b5563; border: 1px solid #4b5563;"
                        onmouseover="this.style.backgroundColor='#374151'"
                        onmouseout="this.style.backgroundColor='#4b5563'">
                    <i class="fas fa-search mr-2"></i>
                    Filtrar
                </button>
            </div>
        </form>
    </div>

    <!-- Tabela de Leituras -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">
                Histórico de Leituras ({{ $leituras->total() }})
            </h3>
        </div>
        
        @if($leituras->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full table-fixed divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Data & Hora</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Níveis</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Volumes</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Caudais</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status & Validação</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($leituras as $leitura)
                        <tr class="hover:bg-gray-50">
                            <!-- Data & Hora -->
                            <td class="w-1/6 px-6 py-4 break-words">
                                <div class="text-sm font-medium text-gray-900">
                                    {{ $leitura->data_leitura->format('d/m/Y') }}
                                </div>
                                <div class="text-sm text-gray-500">
                                    {{ $leitura->hora_leitura ?? '06:00' }}
                                </div>
                                <div class="text-xs text-gray-400">
                                    {{ ucfirst($leitura->metodo_leitura ?? 'Manual') }}
                                </div>
                            </td>

                            <!-- Níveis -->
                            <td class="w-1/6 px-6 py-4 break-words">
                                <div class="space-y-1">
                                    <div class="flex items-center">
                                        <span class="text-sm font-medium text-blue-600">{{ number_format($leitura->cota_actual, 2) }}m</span>
                                        <span class="text-xs text-gray-500 ml-2">Cota</span>
                                    </div>
                                    @if($leitura->percentagem_enchimento)
                                        <div class="flex items-center">
                                            <span class="text-sm font-medium text-purple-600">{{ number_format($leitura->percentagem_enchimento, 1) }}%</span>
                                            <span class="text-xs text-gray-500 ml-2">Enchimento</span>
                                        </div>
                                    @endif
                                </div>
                            </td>

                            <!-- Volumes -->
                            <td class="w-1/6 px-6 py-4 break-words">
                                <div class="space-y-1">
                                    @if($leitura->volume_actual)
                                        <div class="flex items-center">
                                            <span class="text-sm font-medium text-green-600">{{ number_format($leitura->volume_actual, 2) }}</span>
                                            <span class="text-xs text-gray-500 ml-1">Mm³</span>
                                        </div>
                                    @endif
                                    @if($leitura->variacao_volume)
                                        <div class="flex items-center">
                                            @if($leitura->variacao_volume > 0)
                                                <i class="fas fa-arrow-up text-green-500 mr-1"></i>
                                                <span class="text-xs text-green-600">+{{ number_format($leitura->variacao_volume, 2) }}</span>
                                            @elseif($leitura->variacao_volume < 0)
                                                <i class="fas fa-arrow-down text-red-500 mr-1"></i>
                                                <span class="text-xs text-red-600">{{ number_format($leitura->variacao_volume, 2) }}</span>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            </td>

                            <!-- Caudais -->
                            <td class="w-1/6 px-6 py-4 break-words">
                                <div class="space-y-1">
                                    @if($leitura->caudal_afluente)
                                        <div class="text-xs">
                                            <i class="fas fa-arrow-right text-green-500 mr-1"></i>
                                            <span class="text-green-600">{{ number_format($leitura->caudal_afluente, 1) }} m³/s</span>
                                        </div>
                                    @endif
                                    @if($leitura->caudal_efluente)
                                        <div class="text-xs">
                                            <i class="fas fa-arrow-left text-blue-500 mr-1"></i>
                                            <span class="text-blue-600">{{ number_format($leitura->caudal_efluente, 1) }} m³/s</span>
                                        </div>
                                    @endif
                                    @if($leitura->descarga_total)
                                        <div class="text-xs">
                                            <i class="fas fa-water text-gray-500 mr-1"></i>
                                            <span class="text-gray-600">{{ number_format($leitura->descarga_total, 1) }} m³/s total</span>
                                        </div>
                                    @endif
                                </div>
                            </td>

                            <!-- Status & Validação -->
                            <td class="w-1/6 px-6 py-4 break-words">
                                <div class="space-y-2">
                                    @if($leitura->validado)
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs bg-green-100 text-green-800">
                                            <i class="fas fa-check-circle mr-1"></i>
                                            Validado
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs bg-yellow-100 text-yellow-800">
                                            <i class="fas fa-clock mr-1"></i>
                                            Pendente
                                        </span>
                                    @endif

                                    @if($leitura->operador)
                                        <div class="text-xs text-gray-500">
                                            <i class="fas fa-user mr-1"></i>
                                            {{ $leitura->operador->name }}
                                        </div>
                                    @endif
                                </div>
                            </td>

                            <!-- Ações -->
                            <td class="w-1/6 px-6 py-4 break-words text-sm font-medium">
                                <div class="flex items-center space-x-2">
                                    <a href="{{ route('barragens.leituras.edit', [$barragem, $leitura]) }}" class="text-blue-600 hover:text-blue-900" title="Editar">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    @if(!$leitura->validado && auth()->user()->can('validate_readings'))
                                        <form method="POST" action="{{ route('barragens.validateLeitura', [$barragem, $leitura]) }}" class="inline">
                                            @csrf
                                            @method('PUT')
                                            <button type="submit" class="text-green-600 hover:text-green-900" title="Validar">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                    @endif
                                    <form method="POST" action="{{ route('barragens.leituras.destroy', [$barragem, $leitura]) }}" class="inline" onsubmit="return confirm('Tem certeza que deseja excluir esta leitura?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:text-red-900" title="Excluir">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            @if($leituras->hasPages())
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $leituras->withQueryString()->links() }}
            </div>
            @endif
        @else
            <div class="text-center py-12">
                <div class="w-24 h-24 bg-gradient-to-br from-green-100 to-green-200 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <i class="fas fa-chart-line text-4xl text-green-600"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Nenhuma leitura encontrada</h3>
                <p class="text-gray-500 mb-6 max-w-md mx-auto">
                    @if(request()->filled('data_inicio') || request()->filled('data_fim') || request()->filled('metodo'))
                        Nenhuma leitura corresponde aos filtros aplicados. Tente ajustar os critérios de busca.
                    @else
                        Comece adicionando a primeira leitura para esta barragem.
                    @endif
                </p>
                <div class="flex flex-col sm:flex-row gap-3 justify-center">
                    @if(request()->filled('data_inicio') || request()->filled('data_fim') || request()->filled('metodo'))
                        <a href="{{ route('barragens.leituras', $barragem) }}" 
                           class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 transition-colors">
                            <i class="fas fa-times mr-2"></i>
                            Limpar Filtros
                        </a>
                    @endif
                    <a href="#" onclick="toggleNovaLeitura()"
                       class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white transition-colors"
                       style="background-color: #16a34a; border: 1px solid #16a34a;"
                       onmouseover="this.style.backgroundColor='#15803d'"
                       onmouseout="this.style.backgroundColor='#16a34a'">
                        <i class="fas fa-plus mr-2"></i>
                        Adicionar Primeira Leitura
                    </a>
                </div>
            </div>
        @endif
    </div>

    <!-- Formulário Nova Leitura (Inline) -->
    <div id="novaLeituraForm" class="hidden bg-white rounded-lg shadow-lg border-2 border-green-200 transition-all duration-300">
        <div class="px-6 py-4 bg-green-50 border-b border-green-200">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-green-600 rounded-lg flex items-center justify-center mr-3">
                        <i class="fas fa-plus text-white"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-green-900">Nova Leitura</h3>
                        <p class="text-sm text-green-700">{{ $barragem->nome }} • {{ $barragem->codigo }}</p>
                    </div>
                </div>
                <button onclick="toggleNovaLeitura()" class="text-green-600 hover:text-green-800 transition-colors">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
        </div>

        <div class="p-6">
            <form method="POST" action="{{ route('barragens.storeLeitura', $barragem) }}" id="leituraForm">
                @csrf

                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    <!-- Dados Básicos -->
                    <div class="space-y-4">
                        <h4 class="font-medium text-gray-900 flex items-center border-b pb-2">
                            <i class="fas fa-calendar-alt mr-2 text-blue-600"></i>
                            Dados Básicos
                        </h4>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Data da Leitura *</label>
                                <input type="date" name="data_leitura" required value="{{ date('Y-m-d') }}"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Hora da Leitura *</label>
                                <input type="time" name="hora_leitura" required value="06:00"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Método de Leitura</label>
                            <select name="metodo_leitura" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                                <option value="manual">Manual</option>
                                <option value="automatico">Automático</option>
                                <option value="telemetria">Telemetria</option>
                            </select>
                        </div>
                    </div>

                    <!-- Níveis e Volumes -->
                    <div class="space-y-4">
                        <h4 class="font-medium text-gray-900 flex items-center border-b pb-2">
                            <i class="fas fa-water mr-2 text-blue-600"></i>
                            Níveis e Volumes
                        </h4>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Cota Atual (m) *</label>
                            <input type="number" step="0.01" name="cota_actual" required
                                   placeholder="Ex: 425.50"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Volume Atual (Mm³)</label>
                                <input type="number" step="0.01" name="volume_actual"
                                       placeholder="Ex: 150.25"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Volume Morto (Mm³)</label>
                                <input type="number" step="0.01" name="volume_morto"
                                       placeholder="Ex: 5.20"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">% Total</label>
                                <input type="number" step="0.01" name="percentagem_total"
                                       placeholder="Ex: 85.5"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Volume Armazenado (Mm³)</label>
                                <input type="number" step="0.01" name="volume_armazenado"
                                       placeholder="Ex: 200.50"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                            </div>
                        </div>
                    </div>

                    <!-- Caudais -->
                    <div class="space-y-4">
                        <h4 class="font-medium text-gray-900 flex items-center border-b pb-2">
                            <i class="fas fa-water mr-2 text-cyan-600"></i>
                            Caudais (m³/s)
                        </h4>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Afluente</label>
                                <input type="number" step="0.01" name="caudal_afluente"
                                       placeholder="Ex: 5.20"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Efluente</label>
                                <input type="number" step="0.01" name="caudal_efluente"
                                       placeholder="Ex: 3.80"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Descarga de Fundo</label>
                                <input type="number" step="0.01" name="descarga_fundo"
                                       placeholder="Ex: 2.50"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Descarga de Superfície</label>
                                <input type="number" step="0.01" name="descarga_superficie"
                                       placeholder="Ex: 1.20"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Caudal Ecológico</label>
                                <input type="number" step="0.01" name="caudal_ecologico"
                                       placeholder="Ex: 0.50"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Caudal Turbinado</label>
                                <input type="number" step="0.01" name="caudal_turbinado"
                                       placeholder="Ex: 4.20"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Caudal Descarregador</label>
                                <input type="number" step="0.01" name="caudal_descarregador"
                                       placeholder="Ex: 0.80"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Evaporação</label>
                                <input type="number" step="0.01" name="evaporacao"
                                       placeholder="Ex: 0.15"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Infiltração</label>
                                <input type="number" step="0.01" name="infiltracao"
                                       placeholder="Ex: 0.05"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Captação FIPAG</label>
                                <input type="number" step="0.01" name="caudal_captacao"
                                       placeholder="Ex: 2.30"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500">
                            </div>
                        </div>
                    </div>

                    <!-- Outros Dados -->
                    <div class="space-y-4">
                        <h4 class="font-medium text-gray-900 flex items-center border-b pb-2">
                            <i class="fas fa-cloud-rain mr-2 text-blue-600"></i>
                            Dados Meteorológicos
                        </h4>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Precipitação (mm)</label>
                            <input type="number" step="0.1" name="precipitacao"
                                   placeholder="Ex: 12.5"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                        </div>
                    </div>
                </div>

                <!-- Observações -->
                <div class="mt-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-comment mr-1"></i>
                        Observações
                    </label>
                    <textarea name="observacoes" rows="3"
                              placeholder="Observações sobre a leitura, condições meteorológicas, equipamentos, etc."
                              class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500"></textarea>
                </div>

                <!-- Botões -->
                <div class="flex flex-col sm:flex-row justify-end gap-3 mt-8 pt-6 border-t border-gray-200">
                    <button type="button" onclick="toggleNovaLeitura()"
                            class="px-6 py-3 text-gray-700 bg-gray-200 hover:bg-gray-300 rounded-lg transition-colors">
                        <i class="fas fa-times mr-2"></i>
                        Cancelar
                    </button>
                    <button type="submit"
                            class="px-8 py-3 text-white rounded-lg transition-colors font-semibold"
                            style="background-color: #16a34a; border: 1px solid #16a34a;"
                            onmouseover="this.style.backgroundColor='#15803d'"
                            onmouseout="this.style.backgroundColor='#16a34a'">
                        <i class="fas fa-save mr-2"></i>
                        Salvar Leitura
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function toggleNovaLeitura() {
    const form = document.getElementById('novaLeituraForm');
    const btn = document.getElementById('novaLeituraBtn');

    if (form.classList.contains('hidden')) {
        // Mostrar formulário
        form.classList.remove('hidden');
        form.scrollIntoView({ behavior: 'smooth', block: 'center' });

        // Atualizar botão
        if (btn) {
            btn.innerHTML = '<i class="fas fa-times mr-2"></i>Cancelar';
            btn.style.backgroundColor = '#dc2626';
            btn.onmouseover = function() { this.style.backgroundColor = '#b91c1c'; };
            btn.onmouseout = function() { this.style.backgroundColor = '#dc2626'; };
        }

        // Focar no primeiro campo
        setTimeout(() => {
            const firstInput = form.querySelector('input[name="data_leitura"]');
            if (firstInput) firstInput.focus();
        }, 300);
    } else {
        // Esconder formulário
        form.classList.add('hidden');

        // Restaurar botão
        if (btn) {
            btn.innerHTML = '<i class="fas fa-plus mr-2"></i>Nova Leitura';
            btn.style.backgroundColor = '#16a34a';
            btn.onmouseover = function() { this.style.backgroundColor = '#15803d'; };
            btn.onmouseout = function() { this.style.backgroundColor = '#16a34a'; };
        }
    }
}

// Resetar formulário ao esconder
function resetForm() {
    const form = document.getElementById('leituraForm');
    if (form) {
        form.reset();
        // Restaurar valores padrão
        const dataInput = form.querySelector('input[name="data_leitura"]');
        const horaInput = form.querySelector('input[name="hora_leitura"]');
        if (dataInput) dataInput.value = new Date().toISOString().split('T')[0];
        if (horaInput) horaInput.value = '06:00';
    }
}

// Confirmar antes de cancelar se houver dados
function confirmarCancelamento() {
    const form = document.getElementById('leituraForm');
    const formData = new FormData(form);
    let hasData = false;

    for (let [key, value] of formData.entries()) {
        if (key !== '_token' && key !== 'data_leitura' && key !== 'hora_leitura' && value.trim() !== '') {
            hasData = true;
            break;
        }
    }

    if (hasData) {
        return confirm('Tem dados preenchidos. Tem certeza que deseja cancelar?');
    }
    return true;
}

// Atualizar função para incluir confirmação
document.addEventListener('DOMContentLoaded', function() {
    const cancelBtns = document.querySelectorAll('button[onclick*="toggleNovaLeitura"]');
    cancelBtns.forEach(btn => {
        if (btn.textContent.includes('Cancelar')) {
            btn.onclick = function() {
                if (confirmarCancelamento()) {
                    resetForm();
                    toggleNovaLeitura();
                }
            };
        }
    });
});
</script>
@endsection