@extends('layouts.app')

@section('title', 'Detalhes da Barragem - ' . $barragem->nome)

@section('content')
<div class="min-h-screen bg-gray-50">
    <!-- Top Navigation Bar with Actions -->
    <div class="bg-white shadow-sm border-b border-gray-200 sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <!-- Breadcrumb -->
                <nav class="flex items-center space-x-2 text-sm">
                    <a href="{{ route('dashboard') }}" class="text-gray-500 hover:text-blue-600 transition-colors">
                        <i class="fas fa-home mr-1"></i>Dashboard
                    </a>
                    <i class="fas fa-chevron-right text-gray-300"></i>
                    <a href="{{ route('barragens.index') }}" class="text-gray-500 hover:text-blue-600 transition-colors">Barragens</a>
                    <i class="fas fa-chevron-right text-gray-300"></i>
                    <span class="text-gray-900 font-semibold">{{ $barragem->nome }}</span>
                </nav>

                <!-- Quick Actions Toolbar -->
                <div class="flex items-center space-x-2">
                    <button onclick="addReading()"
                            class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white text-sm font-medium rounded-lg transition-colors shadow-sm">
                        <i class="fas fa-plus mr-2"></i>Nova Leitura
                    </button>
                    <a href="{{ route('barragens.leituras', $barragem) }}"
                       class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors shadow-sm">
                        <i class="fas fa-chart-line mr-2"></i>Leituras
                    </a>
                    <a href="/graficos/barragens"
                       class="inline-flex items-center px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white text-sm font-medium rounded-lg transition-colors shadow-sm">
                        <i class="fas fa-chart-area mr-2"></i>Análises
                    </a>
                    <button onclick="generateReport()"
                            class="inline-flex items-center px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white text-sm font-medium rounded-lg transition-colors shadow-sm">
                        <i class="fas fa-file-alt mr-2"></i>Relatório
                    </button>
                    <a href="{{ route('barragens.edit', $barragem) }}"
                       class="inline-flex items-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white text-sm font-medium rounded-lg transition-colors shadow-sm">
                        <i class="fas fa-edit mr-2"></i>Editar
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">

        <!-- Hero Card -->
        <div class="bg-gradient-to-r from-blue-600 to-blue-800 rounded-2xl shadow-xl mb-8 overflow-hidden">
            <div class="px-8 py-8">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-6">
                        <div class="w-20 h-20 bg-white/20 rounded-2xl flex items-center justify-center backdrop-blur">
                            <i class="fas fa-dam text-white text-3xl"></i>
                        </div>
                        <div>
                            <h1 class="text-4xl font-black text-white mb-2">{{ $barragem->nome }}</h1>
                            <p class="text-blue-100 text-lg">Código: <span class="font-mono font-bold">{{ $barragem->codigo }}</span></p>
                        </div>
                    </div>

                    <!-- Status Indicators -->
                    <div class="flex items-center space-x-4">
                        @php
                            $estadoConfig = [
                                'activa' => ['class' => 'bg-green-500 text-white border-green-400', 'icon' => 'fas fa-check-circle', 'label' => 'ATIVA'],
                                'inactiva' => ['class' => 'bg-red-500 text-white border-red-400', 'icon' => 'fas fa-times-circle', 'label' => 'INATIVA'],
                                'manutencao' => ['class' => 'bg-yellow-500 text-white border-yellow-400', 'icon' => 'fas fa-wrench', 'label' => 'MANUTENÇÃO']
                            ];
                            $config = $estadoConfig[$barragem->estado] ?? ['class' => 'bg-gray-500 text-white border-gray-400', 'icon' => 'fas fa-question-circle', 'label' => strtoupper($barragem->estado)];
                        @endphp

                        <div class="text-right text-white">
                            <div class="text-sm text-blue-200">Status da Barragem</div>
                            <div class="inline-flex items-center px-3 py-1 rounded-full text-sm font-bold {{ $config['class'] }} border-2 backdrop-blur">
                                <i class="{{ $config['icon'] }} mr-2"></i>{{ $config['label'] }}
                            </div>
                        </div>

                        @if($barragem->ultima_leitura)
                        <div class="text-right text-white">
                            <div class="text-sm text-blue-200">Última Leitura</div>
                            <div class="text-lg font-bold">{{ $barragem->ultima_leitura->data_leitura->format('d/m/Y') }}</div>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Key Metrics Strip -->
                @if($barragem->ultima_leitura)
                <div class="mt-8 grid grid-cols-2 md:grid-cols-4 gap-4">
                    <!-- Cota -->
                    <div class="bg-white/10 backdrop-blur rounded-xl p-4 border border-white/20">
                        <div class="flex items-center justify-between">
                            <div class="w-10 h-10 bg-blue-500 rounded-lg flex items-center justify-center">
                                <i class="fas fa-ruler-vertical text-white"></i>
                            </div>
                            <div class="text-right">
                                <div class="text-xs text-blue-200 font-semibold">COTA ATUAL</div>
                                <div class="text-2xl font-black text-white">{{ number_format($barragem->ultima_leitura->cota_actual, 1) }}m</div>
                            </div>
                        </div>
                    </div>

                    <!-- Volume -->
                    <div class="bg-white/10 backdrop-blur rounded-xl p-4 border border-white/20">
                        <div class="flex items-center justify-between">
                            <div class="w-10 h-10 bg-green-500 rounded-lg flex items-center justify-center">
                                <i class="fas fa-tint text-white"></i>
                            </div>
                            <div class="text-right">
                                <div class="text-xs text-blue-200 font-semibold">VOLUME</div>
                                <div class="text-2xl font-black text-white">
                                    {{ $barragem->ultima_leitura->volume_actual ? number_format($barragem->ultima_leitura->volume_actual, 1) : '--' }}
                                    <span class="text-sm">Mm³</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Enchimento -->
                    <div class="bg-white/10 backdrop-blur rounded-xl p-4 border border-white/20">
                        <div class="flex items-center justify-between">
                            <div class="w-10 h-10 bg-purple-500 rounded-lg flex items-center justify-center">
                                <i class="fas fa-percentage text-white"></i>
                            </div>
                            <div class="text-right">
                                <div class="text-xs text-blue-200 font-semibold">ENCHIMENTO</div>
                                <div class="text-2xl font-black text-white">{{ number_format($barragem->ultima_leitura->percentagem_enchimento ?? 0, 1) }}%</div>
                            </div>
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="bg-white/10 backdrop-blur rounded-xl p-4 border border-white/20">
                        @php $diasAtras = $barragem->ultima_leitura->data_leitura->diffInDays(now()); @endphp
                        <div class="flex items-center justify-between">
                            <div class="w-10 h-10 bg-{{ $diasAtras == 0 ? 'green' : ($diasAtras <= 3 ? 'yellow' : 'red') }}-500 rounded-lg flex items-center justify-center">
                                <i class="fas fa-satellite text-white"></i>
                            </div>
                            <div class="text-right">
                                <div class="text-xs text-blue-200 font-semibold">DADOS</div>
                                <div class="text-sm font-bold text-white">
                                    @if($diasAtras == 0) Atualizados @elseif($diasAtras <= 1) {{ $diasAtras }} dia @else {{ $diasAtras }} dias @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Main Dashboard Grid -->
        <div class="grid grid-cols-12 gap-8">

            <!-- Left Column - Charts and Analysis -->
            <div class="col-span-12 lg:col-span-8 space-y-8">

                <!-- Interactive Chart -->
                <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                    <div class="border-b border-gray-200 px-6 py-4">
                        <div class="flex items-center justify-between">
                            <div>
                                <h2 class="text-xl font-bold text-gray-900">Análise Temporal</h2>
                                <p class="text-gray-600 text-sm">Evolução dos parâmetros ao longo do tempo</p>
                            </div>
                            <div class="flex items-center space-x-2">
                                <span class="text-xs text-gray-500 font-medium">PERÍODO:</span>
                                <button onclick="updateChartPeriod('7d')"
                                        class="period-btn px-3 py-1 bg-blue-600 text-white rounded-lg text-xs font-bold hover:bg-blue-700 transition-colors" data-period="7d">7d</button>
                                <button onclick="updateChartPeriod('30d')"
                                        class="period-btn px-3 py-1 bg-gray-200 text-gray-700 rounded-lg text-xs font-bold hover:bg-gray-300 transition-colors" data-period="30d">30d</button>
                                <button onclick="updateChartPeriod('1y')"
                                        class="period-btn px-3 py-1 bg-gray-200 text-gray-700 rounded-lg text-xs font-bold hover:bg-gray-300 transition-colors" data-period="1y">1a</button>
                            </div>
                        </div>
                    </div>
                    <div class="p-6">
                        <div class="h-80">
                            <canvas id="damChart" class="w-full h-full"></canvas>
                        </div>
                    </div>
                </div>

                <!-- Technical Data Grid -->
                <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                    <div class="border-b border-gray-200 px-6 py-4">
                        <h2 class="text-xl font-bold text-gray-900">Especificações Técnicas</h2>
                        <p class="text-gray-600 text-sm">Parâmetros técnicos e de segurança</p>
                    </div>
                    <div class="p-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">

                            <!-- Cotas e Níveis -->
                            <div class="border border-gray-200 rounded-xl p-4 hover:bg-gray-50 transition-colors">
                                <div class="flex items-center mb-4">
                                    <div class="w-8 h-8 bg-blue-500 rounded-lg flex items-center justify-center mr-3">
                                        <i class="fas fa-ruler-vertical text-white text-sm"></i>
                                    </div>
                                    <h3 class="font-bold text-gray-900">Cotas & Níveis</h3>
                                </div>
                                <div class="space-y-3 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Máxima:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->cota_maxima ? number_format($barragem->cota_maxima, 1) . 'm' : 'N/A' }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Mínima:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->cota_minima ? number_format($barragem->cota_minima, 1) . 'm' : 'N/A' }}</span>
                                    </div>
                                    @if($barragem->cota_npa)
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">NPA:</span>
                                        <span class="font-bold text-gray-900">{{ number_format($barragem->cota_npa, 1) }}m</span>
                                    </div>
                                    @endif
                                    @if($barragem->cota_nme)
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">NME:</span>
                                        <span class="font-bold text-gray-900">{{ number_format($barragem->cota_nme, 1) }}m</span>
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Volumes -->
                            <div class="border border-gray-200 rounded-xl p-4 hover:bg-gray-50 transition-colors">
                                <div class="flex items-center mb-4">
                                    <div class="w-8 h-8 bg-green-500 rounded-lg flex items-center justify-center mr-3">
                                        <i class="fas fa-tint text-white text-sm"></i>
                                    </div>
                                    <h3 class="font-bold text-gray-900">Volumes</h3>
                                </div>
                                <div class="space-y-3 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Máximo:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->volume_maximo ? number_format($barragem->volume_maximo, 1) . ' Mm³' : 'N/A' }}</span>
                                    </div>
                                    @if($barragem->volume_util)
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Útil:</span>
                                        <span class="font-bold text-gray-900">{{ number_format($barragem->volume_util, 1) }} Mm³</span>
                                    </div>
                                    @endif
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Morto:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->volume_morto ? number_format($barragem->volume_morto, 1) . ' Mm³' : 'N/A' }}</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Segurança -->
                            <div class="border border-gray-200 rounded-xl p-4 hover:bg-gray-50 transition-colors">
                                <div class="flex items-center mb-4">
                                    <div class="w-8 h-8 bg-yellow-500 rounded-lg flex items-center justify-center mr-3">
                                        <i class="fas fa-shield-alt text-white text-sm"></i>
                                    </div>
                                    <h3 class="font-bold text-gray-900">Segurança</h3>
                                </div>
                                <div class="space-y-3 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Alerta:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->nivel_alerta ? number_format($barragem->nivel_alerta, 1) . 'm' : 'N/A' }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Emergência:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->nivel_emergencia ? number_format($barragem->nivel_emergencia, 1) . 'm' : 'N/A' }}</span>
                                    </div>
                                    @if($barragem->classe_risco)
                                    <div class="flex justify-between items-center">
                                        <span class="text-gray-600">Classe Risco:</span>
                                        <span class="px-2 py-1 rounded-full text-xs font-bold
                                            @if($barragem->classe_risco == 'alto') bg-red-100 text-red-800
                                            @elseif($barragem->classe_risco == 'medio') bg-yellow-100 text-yellow-800
                                            @else bg-green-100 text-green-800 @endif">
                                            {{ ucfirst($barragem->classe_risco) }}
                                        </span>
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Características Físicas -->
                            <div class="border border-gray-200 rounded-xl p-4 hover:bg-gray-50 transition-colors">
                                <div class="flex items-center mb-4">
                                    <div class="w-8 h-8 bg-purple-500 rounded-lg flex items-center justify-center mr-3">
                                        <i class="fas fa-mountain text-white text-sm"></i>
                                    </div>
                                    <h3 class="font-bold text-gray-900">Características</h3>
                                </div>
                                <div class="space-y-3 text-sm">
                                    @if($barragem->altura_barragem)
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Altura:</span>
                                        <span class="font-bold text-gray-900">{{ number_format($barragem->altura_barragem, 1) }}m</span>
                                    </div>
                                    @endif
                                    @if($barragem->comprimento_crista)
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Comprimento:</span>
                                        <span class="font-bold text-gray-900">{{ number_format($barragem->comprimento_crista, 0) }}m</span>
                                    </div>
                                    @endif
                                    @if($barragem->tipo_barragem)
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Tipo:</span>
                                        <span class="font-bold text-gray-900 capitalize">{{ $barragem->tipo_barragem }}</span>
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Localização -->
                            <div class="border border-gray-200 rounded-xl p-4 hover:bg-gray-50 transition-colors">
                                <div class="flex items-center mb-4">
                                    <div class="w-8 h-8 bg-red-500 rounded-lg flex items-center justify-center mr-3">
                                        <i class="fas fa-map-marker-alt text-white text-sm"></i>
                                    </div>
                                    <h3 class="font-bold text-gray-900">Localização</h3>
                                </div>
                                <div class="space-y-3 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Província:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->provincia ?? 'N/A' }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Distrito:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->distrito ?? 'N/A' }}</span>
                                    </div>
                                    @if($barragem->bacia_hidrografica)
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Bacia:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->bacia_hidrografica->nome }}</span>
                                    </div>
                                    @endif
                                </div>
                                @if($barragem->latitude && $barragem->longitude)
                                <div class="mt-3 pt-3 border-t border-gray-200">
                                    <x-coordenadas-clicaveis
                                        :latitude="$barragem->latitude"
                                        :longitude="$barragem->longitude"
                                        :nome="$barragem->nome"
                                        tipo="barragem"
                                        :id="$barragem->id"
                                        size="xs" />
                                </div>
                                @endif
                            </div>

                            <!-- Projeto -->
                            @if($barragem->empresa_projetista || $barragem->empresa_construtora || $barragem->ano_projeto)
                            <div class="border border-gray-200 rounded-xl p-4 hover:bg-gray-50 transition-colors">
                                <div class="flex items-center mb-4">
                                    <div class="w-8 h-8 bg-gray-500 rounded-lg flex items-center justify-center mr-3">
                                        <i class="fas fa-building text-white text-sm"></i>
                                    </div>
                                    <h3 class="font-bold text-gray-900">Projeto</h3>
                                </div>
                                <div class="space-y-3 text-sm">
                                    @if($barragem->empresa_projetista)
                                    <div>
                                        <span class="text-gray-600 block">Projetista:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->empresa_projetista }}</span>
                                    </div>
                                    @endif
                                    @if($barragem->empresa_construtora)
                                    <div>
                                        <span class="text-gray-600 block">Construtora:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->empresa_construtora }}</span>
                                    </div>
                                    @endif
                                    @if($barragem->ano_construcao)
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Construção:</span>
                                        <span class="font-bold text-gray-900">{{ $barragem->ano_construcao }}</span>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Sidebar -->
            <div class="col-span-12 lg:col-span-4 space-y-6">

                @if($barragem->ultima_leitura)
                <!-- Current Status -->
                <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                    <div class="bg-gradient-to-r from-green-600 to-emerald-600 px-6 py-4 text-white">
                        <h3 class="text-lg font-bold flex items-center">
                            <i class="fas fa-tachometer-alt mr-2"></i>Status Operacional
                        </h3>
                    </div>
                    <div class="p-6">
                        @if($barragem->ultima_leitura->caudal_afluente || $barragem->ultima_leitura->caudal_efluente)
                        <div class="mb-6">
                            <h4 class="font-bold text-gray-900 mb-3 flex items-center">
                                <i class="fas fa-water mr-2 text-blue-500"></i>Caudais (m³/s)
                            </h4>
                            <div class="space-y-2">
                                @if($barragem->ultima_leitura->caudal_afluente)
                                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                                    <span class="text-gray-600">Afluente:</span>
                                    <span class="font-bold text-lg text-blue-600">{{ number_format($barragem->ultima_leitura->caudal_afluente, 1) }}</span>
                                </div>
                                @endif
                                @if($barragem->ultima_leitura->caudal_efluente)
                                <div class="flex justify-between items-center py-2 border-b border-gray-100">
                                    <span class="text-gray-600">Efluente:</span>
                                    <span class="font-bold text-lg text-green-600">{{ number_format($barragem->ultima_leitura->caudal_efluente, 1) }}</span>
                                </div>
                                @endif
                            </div>
                        </div>
                        @endif

                        <div class="mb-6">
                            <h4 class="font-bold text-gray-900 mb-3 flex items-center">
                                <i class="fas fa-certificate mr-2 text-purple-500"></i>Qualidade dos Dados
                            </h4>
                            <div class="space-y-3">
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-600">Método:</span>
                                    <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded-lg text-sm font-medium">
                                        {{ ucfirst($barragem->ultima_leitura->metodo_leitura ?? 'Manual') }}
                                    </span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span class="text-gray-600">Atualização:</span>
                                    <span class="text-sm font-medium text-gray-900">
                                        {{ $barragem->ultima_leitura->data_leitura->format('d/m/Y H:i') }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                <!-- Quick Tools -->
                <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                    <div class="bg-gradient-to-r from-blue-600 to-indigo-600 px-6 py-4 text-white">
                        <h3 class="text-lg font-bold flex items-center">
                            <i class="fas fa-tools mr-2"></i>Ferramentas Rápidas
                        </h3>
                    </div>
                    <div class="p-6">
                        <div class="space-y-3">
                            <button onclick="addReading()"
                                    class="w-full bg-gradient-to-r from-green-500 to-emerald-600 hover:from-green-600 hover:to-emerald-700 text-white rounded-xl py-4 px-4 font-bold transition-all shadow-md hover:shadow-lg flex items-center justify-center">
                                <i class="fas fa-plus-circle mr-3"></i>Adicionar Leitura
                            </button>
                            <a href="{{ route('barragens.leituras', $barragem) }}"
                               class="w-full block bg-gradient-to-r from-blue-500 to-indigo-600 hover:from-blue-600 hover:to-indigo-700 text-white rounded-xl py-4 px-4 font-bold transition-all shadow-md hover:shadow-lg text-center">
                                <i class="fas fa-list mr-3"></i>Ver Histórico
                            </a>
                            <button onclick="generateReport()"
                                    class="w-full bg-gradient-to-r from-orange-500 to-red-600 hover:from-orange-600 hover:to-red-700 text-white rounded-xl py-4 px-4 font-bold transition-all shadow-md hover:shadow-lg flex items-center justify-center">
                                <i class="fas fa-file-pdf mr-3"></i>Gerar Relatório
                            </button>
                            <a href="{{ route('barragens.curvas-volume.index', $barragem) }}"
                               class="w-full block bg-gradient-to-r from-purple-500 to-violet-600 hover:from-purple-600 hover:to-violet-700 text-white rounded-xl py-4 px-4 font-bold transition-all shadow-md hover:shadow-lg text-center">
                                <i class="fas fa-chart-area mr-3"></i>Curvas Volume
                            </a>
                        </div>
                    </div>
                </div>

                <!-- System Information -->
                <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                    <div class="bg-gradient-to-r from-gray-600 to-slate-600 px-6 py-4 text-white">
                        <h3 class="text-lg font-bold flex items-center">
                            <i class="fas fa-info-circle mr-2"></i>Informações do Sistema
                        </h3>
                    </div>
                    <div class="p-6">
                        @if($barragem->observacoes)
                        <div class="mb-4 p-4 bg-yellow-50 border-l-4 border-yellow-400 rounded-r-lg">
                            <h4 class="font-bold text-yellow-800 mb-2">Observações:</h4>
                            <p class="text-sm text-yellow-700">{{ $barragem->observacoes }}</p>
                        </div>
                        @endif

                        <div class="space-y-3 text-sm">
                            <div class="flex justify-between py-2 border-b border-gray-100">
                                <span class="text-gray-600">Criado:</span>
                                <span class="font-medium">{{ $barragem->created_at->format('d/m/Y') }}</span>
                            </div>
                            <div class="flex justify-between py-2">
                                <span class="text-gray-600">Atualizado:</span>
                                <span class="font-medium">{{ $barragem->updated_at->format('d/m/Y') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
let damChart = null;
let currentPeriod = '7d';

function generateReport() {
    alert('Funcionalidade de relatório será implementada em breve.');
}

function addReading() {
    window.location.href = '{{ route("barragens.leituras", $barragem) }}';
}

// Chart functions
function initializeDamChart() {
    const ctx = document.getElementById('damChart').getContext('2d');

    damChart = new Chart(ctx, {
        type: 'line',
        data: { labels: [], datasets: [] },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: { usePointStyle: true, padding: 20, font: { weight: 'bold' } }
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    titleFont: { weight: 'bold' },
                    bodyFont: { weight: 'bold' },
                    cornerRadius: 8
                }
            },
            scales: {
                y: {
                    beginAtZero: false,
                    grid: { color: 'rgba(0, 0, 0, 0.1)' },
                    ticks: { font: { weight: 'bold' } },
                    title: { display: true, text: 'Cota (m)', color: 'rgb(59, 130, 246)', font: { weight: 'bold' } }
                },
                y1: {
                    type: 'linear', display: true, position: 'right',
                    grid: { drawOnChartArea: false },
                    ticks: { font: { weight: 'bold' } },
                    title: { display: true, text: 'Volume (Mm³)', color: 'rgb(34, 197, 94)', font: { weight: 'bold' } }
                },
                y2: { type: 'linear', display: false, min: 0, max: 100 },
                x: { grid: { color: 'rgba(0, 0, 0, 0.1)' }, ticks: { font: { weight: 'bold' } } }
            },
            elements: { line: { tension: 0.4 }, point: { radius: 4, hoverRadius: 8 } }
        }
    });

    updateChartData(currentPeriod);
}

function updateChartData(period) {
    const url = `/api/barragens/{{ $barragem->id }}/chart-data?period=${period}`;
    const chartContainer = document.getElementById('damChart').parentElement;

    chartContainer.innerHTML = '<div class="flex items-center justify-center h-80"><div class="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600"></div></div>';

    fetch(url)
        .then(response => response.json())
        .then(data => {
            chartContainer.innerHTML = '<canvas id="damChart" class="w-full h-full"></canvas>';
            const ctx = document.getElementById('damChart').getContext('2d');

            if (damChart) damChart.destroy();

            damChart = new Chart(ctx, {
                type: 'line',
                data: { labels: data.labels || [], datasets: data.datasets || [] },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        title: {
                            display: true,
                            text: `BARRAGEM ${data.barragem_nome ? data.barragem_nome.toUpperCase() : '{{ strtoupper($barragem->nome) }}'}`,
                            font: { size: 18, weight: 'bold' },
                            color: '#1f2937',
                            padding: { bottom: 30 }
                        },
                        legend: {
                            position: 'bottom',
                            labels: {
                                usePointStyle: false,
                                padding: 20,
                                font: { weight: 'bold', size: 12 },
                                generateLabels: function(chart) {
                                    const labels = chart.data.datasets.map((dataset, i) => ({
                                        text: dataset.label,
                                        fillStyle: dataset.borderColor,
                                        strokeStyle: dataset.borderColor,
                                        lineWidth: dataset.type === 'bar' ? 0 : 3,
                                        hidden: !chart.isDatasetVisible(i),
                                        datasetIndex: i
                                    }));
                                    return labels;
                                }
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.8)',
                            titleFont: { weight: 'bold' },
                            bodyFont: { weight: 'bold' },
                            cornerRadius: 8,
                            callbacks: {
                                label: function(context) {
                                    let label = context.dataset.label || '';
                                    if (label) {
                                        label += ': ';
                                    }
                                    if (label.includes('Precipitação')) {
                                        label += context.parsed.y.toFixed(1) + ' mm';
                                    } else if (label.includes('Volume')) {
                                        label += context.parsed.y.toFixed(2) + ' Mm³';
                                    } else {
                                        label += context.parsed.y.toFixed(2) + ' m';
                                    }
                                    return label;
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: false,
                            grid: {
                                color: 'rgba(0, 0, 0, 0.3)',
                                lineWidth: 1,
                                drawBorder: true
                            },
                            ticks: {
                                font: { weight: 'bold', size: 11 },
                                color: '#374151',
                                stepSize: period === '1y' ? 0.5 : undefined,
                                callback: function(value) {
                                    return value.toFixed(1);
                                }
                            },
                            title: {
                                display: true,
                                text: 'Cota (m)',
                                color: '#1f2937',
                                font: { weight: 'bold', size: 14 },
                                padding: { bottom: 10 }
                            },
                            min: period === '1y' ? 996 : undefined,
                            max: period === '1y' ? 1002 : undefined
                        },
                        y1: {
                            type: 'linear',
                            display: period !== '1y',
                            position: 'right',
                            grid: { drawOnChartArea: false },
                            ticks: {
                                font: { weight: 'bold', size: 11 },
                                color: '#059669'
                            },
                            title: {
                                display: true,
                                text: 'Volume (Mm³)',
                                color: '#059669',
                                font: { weight: 'bold', size: 14 }
                            }
                        },
                        y2: {
                            type: 'linear',
                            display: period === '1y',
                            position: 'right',
                            min: 0,
                            max: 60,
                            reverse: true, // Inverte a escala como no gráfico original
                            grid: { drawOnChartArea: false },
                            ticks: {
                                font: { weight: 'bold', size: 11 },
                                color: '#7c3aed',
                                stepSize: 10,
                                callback: function(value) {
                                    return value.toFixed(1);
                                }
                            },
                            title: {
                                display: true,
                                text: 'Precipitação (mm)',
                                color: '#7c3aed',
                                font: { weight: 'bold', size: 14 },
                                padding: { bottom: 10 }
                            }
                        },
                        x: {
                            grid: {
                                color: 'rgba(0, 0, 0, 0.3)',
                                lineWidth: 1,
                                drawBorder: true
                            },
                            ticks: {
                                font: { weight: 'bold', size: 11 },
                                color: '#374151'
                            }
                        }
                    },
                    elements: {
                        line: { tension: 0.1 },
                        point: { radius: 4, hoverRadius: 6 },
                        bar: { borderWidth: 1 }
                    }
                }
            });
        })
        .catch(error => {
            console.error('Erro ao carregar dados do gráfico:', error);
            chartContainer.innerHTML = '<div class="flex items-center justify-center h-80 text-red-500"><i class="fas fa-exclamation-triangle mr-2"></i>Erro ao carregar dados</div>';
        });
}

function updateChartPeriod(period) {
    currentPeriod = period;

    document.querySelectorAll('.period-btn').forEach(btn => {
        btn.classList.remove('bg-blue-600', 'text-white');
        btn.classList.add('bg-gray-200', 'text-gray-700');
    });

    const selectedBtn = document.querySelector(`[data-period="${period}"]`);
    if (selectedBtn) {
        selectedBtn.classList.remove('bg-gray-200', 'text-gray-700');
        selectedBtn.classList.add('bg-blue-600', 'text-white');
    }

    updateChartData(period);
}

document.addEventListener('DOMContentLoaded', function() {
    setTimeout(() => {
        const chartCanvas = document.getElementById('damChart');
        if (chartCanvas) {
            initializeDamChart();
        }
    }, 100);
});
</script>
@endsection