@extends('layouts.app')

@section('title', 'Boletins')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-file-alt mr-3 text-blue-600"></i>
                    Boletins Hidrológicos
                </h1>
                <p class="text-gray-600 mt-2">Gestão e geração de boletins em PDF, Word e Excel</p>
            </div>
            <a href="{{ route('boletins.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center">
                <i class="fas fa-plus mr-2"></i>
                Gerar Boletim
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow p-6">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Tipo</label>
                <select name="tipo" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Todos os tipos</option>
                    <option value="hidrologico_regional" {{ request('tipo') == 'hidrologico_regional' ? 'selected' : '' }}>Hidrológico Regional</option>
                    <option value="hidrologico_provincial" {{ request('tipo') == 'hidrologico_provincial' ? 'selected' : '' }}>Hidrológico Provincial</option>
                    <option value="informativo_barragens" {{ request('tipo') == 'informativo_barragens' ? 'selected' : '' }}>Informativo de Barragens</option>
                    <option value="diario" {{ request('tipo') == 'diario' ? 'selected' : '' }}>Diário</option>
                    <option value="semanal" {{ request('tipo') == 'semanal' ? 'selected' : '' }}>Semanal</option>
                    <option value="mensal" {{ request('tipo') == 'mensal' ? 'selected' : '' }}>Mensal</option>
                    <option value="emergencia" {{ request('tipo') == 'emergencia' ? 'selected' : '' }}>Emergência</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Estado</label>
                <select name="estado" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Todos os estados</option>
                    <option value="rascunho" {{ request('estado') == 'rascunho' ? 'selected' : '' }}>Rascunho</option>
                    <option value="revisao" {{ request('estado') == 'revisao' ? 'selected' : '' }}>Em Revisão</option>
                    <option value="aprovado" {{ request('estado') == 'aprovado' ? 'selected' : '' }}>Aprovado</option>
                    <option value="publicado" {{ request('estado') == 'publicado' ? 'selected' : '' }}>Publicado</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                <input type="date" name="data_inicio" value="{{ request('data_inicio') }}" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            <div class="flex items-end">
                <button type="submit" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg w-full">
                    <i class="fas fa-search mr-2"></i>
                    Filtrar
                </button>
            </div>
        </form>
    </div>

    <!-- Boletins List -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">
                Boletins ({{ $boletins->total() }})
            </h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Edição</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tipo</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Período</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Estado</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Data Emissão</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($boletins as $boletim)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900">{{ $boletim->numero_edicao ?? 'N/A' }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                @if($boletim->tipo == 'hidrologico_regional') bg-blue-100 text-blue-800
                                @elseif($boletim->tipo == 'hidrologico_provincial') bg-purple-100 text-purple-800
                                @elseif($boletim->tipo == 'informativo_barragens') bg-green-100 text-green-800
                                @elseif($boletim->tipo == 'emergencia') bg-red-100 text-red-800
                                @else bg-gray-100 text-gray-800 @endif">
                                {{ $boletim->getTipoFormatado() }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                            @if($boletim->periodo_inicio && $boletim->periodo_fim)
                                {{ $boletim->periodo_inicio->format('d/m/Y') }} - {{ $boletim->periodo_fim->format('d/m/Y') }}
                            @else
                                {{ $boletim->data_emissao->format('d/m/Y') }}
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                @if($boletim->estado == 'rascunho') bg-yellow-100 text-yellow-800
                                @elseif($boletim->estado == 'revisao') bg-orange-100 text-orange-800
                                @elseif($boletim->estado == 'aprovado') bg-blue-100 text-blue-800
                                @elseif($boletim->estado == 'publicado') bg-green-100 text-green-800
                                @else bg-gray-100 text-gray-800 @endif">
                                {{ $boletim->getEstadoFormatado() }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            {{ $boletim->data_emissao->format('d/m/Y') }} às {{ $boletim->hora_emissao ? substr($boletim->hora_emissao, 0, 5) : '00:00' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <div class="flex space-x-2">
                                <a href="{{ route('boletins.show', $boletim) }}" class="text-blue-600 hover:text-blue-900" title="Visualizar">
                                    <i class="fas fa-eye"></i>
                                </a>
                                
                                @if($boletim->podeSerEditado())
                                <a href="{{ route('boletins.edit', $boletim) }}" class="text-green-600 hover:text-green-900" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @endif

                                @if($boletim->arquivo_pdf)
                                <a href="{{ route('boletins.download-pdf', $boletim) }}" class="text-red-600 hover:text-red-900" title="Download PDF">
                                    <i class="fas fa-file-pdf"></i>
                                </a>
                                @endif

                                <div class="dropdown">
                                    <button class="text-gray-600 hover:text-gray-900" type="button" data-dropdown-toggle="dropdown-{{ $boletim->id }}">
                                        <i class="fas fa-download"></i>
                                    </button>
                                    <div class="hidden dropdown-menu absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5" id="dropdown-{{ $boletim->id }}">
                                        <div class="py-1">
                                            <a href="{{ route('boletins.export', ['boletim' => $boletim, 'format' => 'pdf']) }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                                <i class="fas fa-file-pdf mr-2"></i>Exportar PDF
                                            </a>
                                            <a href="{{ route('boletins.export', ['boletim' => $boletim, 'format' => 'word']) }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                                <i class="fas fa-file-word mr-2"></i>Exportar Word
                                            </a>
                                            <a href="{{ route('boletins.export', ['boletim' => $boletim, 'format' => 'excel']) }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                                <i class="fas fa-file-excel mr-2"></i>Exportar Excel
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center">
                            <div class="text-gray-500">
                                <i class="fas fa-file-alt text-4xl mb-4"></i>
                                <p>Nenhum boletim encontrado</p>
                                <a href="{{ route('boletins.create') }}" class="text-blue-600 hover:text-blue-800 mt-2 inline-block">
                                    Gerar primeiro boletim
                                </a>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        @if($boletins->hasPages())
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $boletins->withQueryString()->links() }}
        </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
// Simple dropdown functionality
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('[data-dropdown-toggle]').forEach(function(trigger) {
        trigger.addEventListener('click', function() {
            const targetId = this.getAttribute('data-dropdown-toggle');
            const dropdown = document.getElementById(targetId);
            dropdown.classList.toggle('hidden');
        });
    });

    // Close dropdowns when clicking outside
    document.addEventListener('click', function(event) {
        if (!event.target.closest('[data-dropdown-toggle]')) {
            document.querySelectorAll('.dropdown-menu').forEach(function(dropdown) {
                dropdown.classList.add('hidden');
            });
        }
    });
});
</script>
@endpush
@endsection