@extends('layouts.app')

@section('title', 'Configurações Email/SMTP')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">
                    <i class="fas fa-envelope mr-3 text-blue-600"></i>
                    Configurações Email/SMTP
                </h1>
                <p class="text-gray-600 mt-2">Configure o servidor SMTP para envio de notificações por email</p>
            </div>
            <div class="flex items-center space-x-2">
                @if($config['host'])
                    <div class="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
                    <span class="text-sm text-green-600">Configurado</span>
                @else
                    <div class="w-3 h-3 bg-red-500 rounded-full"></div>
                    <span class="text-sm text-red-600">Não configurado</span>
                @endif
            </div>
        </div>
    </div>

    <!-- Estatísticas -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-blue-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Emails Hoje</p>
                    <p class="text-3xl font-bold text-blue-600">{{ $stats['emails_enviados_hoje'] }}</p>
                    <p class="text-xs text-gray-500">Enviados hoje</p>
                </div>
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-paper-plane text-2xl text-blue-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-green-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Emails Mês</p>
                    <p class="text-3xl font-bold text-green-600">{{ $stats['emails_enviados_mes'] }}</p>
                    <p class="text-xs text-gray-500">Enviados este mês</p>
                </div>
                <div class="bg-green-100 p-3 rounded-lg">
                    <i class="fas fa-calendar text-2xl text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-purple-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Usuários Email</p>
                    <p class="text-3xl font-bold text-purple-600">{{ $stats['usuarios_com_email'] }}</p>
                    <p class="text-xs text-gray-500">Com email ativado</p>
                </div>
                <div class="bg-purple-100 p-3 rounded-lg">
                    <i class="fas fa-users text-2xl text-purple-600"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Configurações SMTP -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-6">
                <i class="fas fa-cog mr-2 text-blue-600"></i>
                Configurações SMTP
            </h3>

            @if ($errors->any())
                <div class="mb-4 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded">
                    <ul class="list-disc list-inside">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if (session('success'))
                <div class="mb-4 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded">
                    {{ session('success') }}
                </div>
            @endif

            <form method="POST" action="{{ route('configuracoes.email.update') }}" class="space-y-4">
                @csrf
                @method('PUT')

                <div>
                    <label for="mail_host" class="block text-sm font-medium text-gray-700 mb-1">
                        Servidor SMTP *
                    </label>
                    <input type="text" 
                           id="mail_host" 
                           name="mail_host" 
                           value="{{ old('mail_host', $config['host']) }}" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                           placeholder="smtp.gmail.com" 
                           required>
                    <p class="text-xs text-gray-500 mt-1">Endereço do servidor SMTP</p>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label for="mail_port" class="block text-sm font-medium text-gray-700 mb-1">
                            Porta *
                        </label>
                        <input type="number" 
                               id="mail_port" 
                               name="mail_port" 
                               value="{{ old('mail_port', $config['port']) }}" 
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                               placeholder="587" 
                               required>
                    </div>

                    <div>
                        <label for="mail_encryption" class="block text-sm font-medium text-gray-700 mb-1">
                            Criptografia
                        </label>
                        <select id="mail_encryption" 
                                name="mail_encryption" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Nenhuma</option>
                            <option value="tls" {{ old('mail_encryption', $config['encryption']) == 'tls' ? 'selected' : '' }}>TLS</option>
                            <option value="ssl" {{ old('mail_encryption', $config['encryption']) == 'ssl' ? 'selected' : '' }}>SSL</option>
                        </select>
                    </div>
                </div>

                <div>
                    <label for="mail_username" class="block text-sm font-medium text-gray-700 mb-1">
                        Nome de Usuário *
                    </label>
                    <input type="text" 
                           id="mail_username" 
                           name="mail_username" 
                           value="{{ old('mail_username', $config['username']) }}" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                           placeholder="usuario@email.com" 
                           required>
                    <p class="text-xs text-gray-500 mt-1">Usuário para autenticação SMTP</p>
                </div>

                <div>
                    <label for="mail_password" class="block text-sm font-medium text-gray-700 mb-1">
                        Senha
                    </label>
                    <input type="password" 
                           id="mail_password" 
                           name="mail_password" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                           placeholder="Deixe em branco para manter a atual">
                    <p class="text-xs text-gray-500 mt-1">Senha para autenticação SMTP</p>
                </div>

                <div>
                    <label for="mail_from_address" class="block text-sm font-medium text-gray-700 mb-1">
                        Email Remetente *
                    </label>
                    <input type="email" 
                           id="mail_from_address" 
                           name="mail_from_address" 
                           value="{{ old('mail_from_address', $config['from_address']) }}" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                           placeholder="sistema@empresa.com" 
                           required>
                    <p class="text-xs text-gray-500 mt-1">Email que aparecerá como remetente</p>
                </div>

                <div>
                    <label for="mail_from_name" class="block text-sm font-medium text-gray-700 mb-1">
                        Nome Remetente *
                    </label>
                    <input type="text" 
                           id="mail_from_name" 
                           name="mail_from_name" 
                           value="{{ old('mail_from_name', $config['from_name']) }}" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                           placeholder="Sistema Hidrológico" 
                           required>
                    <p class="text-xs text-gray-500 mt-1">Nome que aparecerá como remetente</p>
                </div>

                <div class="flex items-center">
                    <input type="checkbox" 
                           id="email_enabled" 
                           name="email_enabled" 
                           value="1" 
                           {{ old('email_enabled', $config['email_enabled']) ? 'checked' : '' }}
                           class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                    <label for="email_enabled" class="ml-2 block text-sm text-gray-900">
                        Ativar envio de emails
                    </label>
                </div>

                <div class="pt-4 border-t border-gray-200">
                    <button type="submit" class="w-full bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors flex items-center justify-center">
                        <i class="fas fa-save mr-2"></i>
                        Salvar Configurações
                    </button>
                </div>
            </form>
        </div>

        <!-- Status e Informações -->
        <div class="space-y-6">
            <!-- Status das configurações -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">
                    <i class="fas fa-info-circle mr-2 text-blue-600"></i>
                    Status das Configurações
                </h3>
                
                <div class="space-y-3">
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Servidor SMTP:</span>
                        <span class="font-medium">{{ $config['host'] ?: 'N/A' }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Porta:</span>
                        <span class="font-medium">{{ $config['port'] ?: 'N/A' }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Criptografia:</span>
                        <span class="font-medium">{{ $config['encryption'] ?: 'Nenhuma' }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Usuário:</span>
                        <span class="font-medium">{{ $config['username'] ?: 'N/A' }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Senha:</span>
                        <span class="font-medium text-{{ $config['password'] ? 'green' : 'red' }}-600">
                            {{ $config['password'] ? 'Configurada' : 'Não configurada' }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Email Remetente:</span>
                        <span class="font-medium">{{ $config['from_address'] ?: 'N/A' }}</span>
                    </div>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-600">Email Ativo:</span>
                        <span class="font-medium text-{{ $config['email_enabled'] ? 'green' : 'red' }}-600">
                            {{ $config['email_enabled'] ? 'Sim' : 'Não' }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Teste de Email -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">
                    <i class="fas fa-test-tube mr-2 text-green-600"></i>
                    Teste de Email
                </h3>

                <div class="mb-4 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded">
                    <p class="text-sm">
                        <i class="fas fa-info-circle mr-2"></i>
                        Funcionalidade em desenvolvimento. Em breve será possível testar o envio de emails.
                    </p>
                </div>

                <form class="space-y-4 opacity-50">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">
                            Email para Teste
                        </label>
                        <input type="email" 
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm"
                               placeholder="teste@exemplo.com" 
                               disabled>
                    </div>

                    <button type="button" 
                            class="w-full bg-gray-400 text-white px-4 py-2 rounded-md cursor-not-allowed flex items-center justify-center" 
                            disabled>
                        <i class="fas fa-paper-plane mr-2"></i>
                        Enviar Email de Teste (Em breve)
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Provedores Comuns -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-6">
            <i class="fas fa-server mr-2 text-green-600"></i>
            Configurações para Provedores Comuns
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- Gmail -->
            <div class="p-4 border border-gray-200 rounded-lg">
                <h4 class="font-semibold text-gray-900 mb-3 flex items-center">
                    <i class="fab fa-google mr-2 text-red-500"></i>
                    Gmail
                </h4>
                <div class="text-sm text-gray-600 space-y-1">
                    <p><strong>Servidor:</strong> smtp.gmail.com</p>
                    <p><strong>Porta:</strong> 587</p>
                    <p><strong>Criptografia:</strong> TLS</p>
                    <p><strong>Nota:</strong> Use senha de app</p>
                </div>
            </div>

            <!-- Outlook -->
            <div class="p-4 border border-gray-200 rounded-lg">
                <h4 class="font-semibold text-gray-900 mb-3 flex items-center">
                    <i class="fab fa-microsoft mr-2 text-blue-500"></i>
                    Outlook/Hotmail
                </h4>
                <div class="text-sm text-gray-600 space-y-1">
                    <p><strong>Servidor:</strong> smtp-mail.outlook.com</p>
                    <p><strong>Porta:</strong> 587</p>
                    <p><strong>Criptografia:</strong> TLS</p>
                </div>
            </div>

            <!-- Yahoo -->
            <div class="p-4 border border-gray-200 rounded-lg">
                <h4 class="font-semibold text-gray-900 mb-3 flex items-center">
                    <i class="fab fa-yahoo mr-2 text-purple-500"></i>
                    Yahoo
                </h4>
                <div class="text-sm text-gray-600 space-y-1">
                    <p><strong>Servidor:</strong> smtp.mail.yahoo.com</p>
                    <p><strong>Porta:</strong> 587</p>
                    <p><strong>Criptografia:</strong> TLS</p>
                </div>
            </div>
        </div>

        <div class="mt-6 p-4 bg-yellow-50 border border-yellow-200 rounded-md">
            <p class="text-sm text-yellow-800">
                <i class="fas fa-exclamation-triangle mr-2"></i>
                <strong>Dica de Segurança:</strong> Para Gmail, use senhas de aplicativo em vez da senha normal da conta. 
                Ative a autenticação de dois fatores e gere uma senha específica para esta aplicação.
            </p>
        </div>
    </div>

    <!-- Ações Rápidas -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">
            <i class="fas fa-bolt mr-2 text-yellow-600"></i>
            Ações Rápidas
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <a href="{{ route('notifications.historico') }}" class="flex items-center justify-center p-4 border border-blue-300 bg-blue-50 text-blue-700 rounded-lg hover:bg-blue-100 transition-colors">
                <i class="fas fa-history mr-2"></i>
                Histórico Emails
            </a>
            
            <a href="{{ route('notifications.dashboard') }}" class="flex items-center justify-center p-4 border border-purple-300 bg-purple-50 text-purple-700 rounded-lg hover:bg-purple-100 transition-colors">
                <i class="fas fa-chart-bar mr-2"></i>
                Dashboard Notificações
            </a>
            
            <a href="{{ route('configuracoes.index') }}" class="flex items-center justify-center p-4 border border-gray-300 bg-gray-50 text-gray-700 rounded-lg hover:bg-gray-100 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar às Configurações
            </a>
        </div>
    </div>
</div>
@endsection