@extends('layouts.app')

@section('title', 'Configurações do Sistema')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">
                    <i class="fas fa-cogs mr-3 text-blue-600"></i>
                    Configurações do Sistema
                </h1>
                <p class="text-gray-600 mt-2">Gerir todas as configurações e parâmetros do sistema hidrológico</p>
            </div>
            <div class="flex items-center space-x-2">
                <div class="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
                <span class="text-sm text-green-600">Sistema operacional</span>
            </div>
        </div>
    </div>

    <!-- Estatísticas do Sistema -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-blue-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Usuários Ativos</p>
                    <p class="text-3xl font-bold text-blue-600">{{ $stats['usuarios_ativos'] }}</p>
                    <p class="text-xs text-gray-500">de {{ $stats['usuarios_total'] }} total</p>
                </div>
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-users text-2xl text-blue-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-green-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Infraestruturas</p>
                    <p class="text-3xl font-bold text-green-600">{{ $stats['barragens_total'] + $stats['estacoes_total'] }}</p>
                    <p class="text-xs text-gray-500">{{ $stats['barragens_total'] }} barragens, {{ $stats['estacoes_total'] }} estações</p>
                </div>
                <div class="bg-green-100 p-3 rounded-lg">
                    <i class="fas fa-water text-2xl text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-red-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Alertas Ativos</p>
                    <p class="text-3xl font-bold text-red-600">{{ $stats['alertas_ativos'] }}</p>
                    <p class="text-xs text-gray-500">Requerem atenção</p>
                </div>
                <div class="bg-red-100 p-3 rounded-lg">
                    <i class="fas fa-exclamation-triangle text-2xl text-red-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-purple-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Leituras Hoje</p>
                    <p class="text-3xl font-bold text-purple-600">{{ $stats['leituras_hoje'] }}</p>
                    <p class="text-xs text-gray-500">Dados coletados</p>
                </div>
                <div class="bg-purple-100 p-3 rounded-lg">
                    <i class="fas fa-chart-line text-2xl text-purple-600"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Cards de Configuração -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        
        <!-- SMS/Twilio -->
        <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center">
                        <div class="bg-green-100 p-3 rounded-lg mr-3">
                            <i class="fas fa-sms text-2xl text-green-600"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">SMS / Twilio</h3>
                            <p class="text-sm text-gray-600">Configurar notificações SMS</p>
                        </div>
                    </div>
                    @if($configuracoes['twilio']['sid'])
                        <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                    @else
                        <div class="w-3 h-3 bg-red-500 rounded-full"></div>
                    @endif
                </div>
                
                <div class="space-y-2 mb-4">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Status:</span>
                        <span class="font-medium text-{{ $configuracoes['twilio']['sid'] ? 'green' : 'red' }}-600">
                            {{ $configuracoes['twilio']['sid'] ? 'Configurado' : 'Não configurado' }}
                        </span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Número:</span>
                        <span class="font-medium">{{ $configuracoes['twilio']['phone_number'] ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">SMS Ativo:</span>
                        <span class="font-medium text-{{ $configuracoes['twilio']['sms_enabled'] ? 'green' : 'red' }}-600">
                            {{ $configuracoes['twilio']['sms_enabled'] ? 'Sim' : 'Não' }}
                        </span>
                    </div>
                </div>
                
                <a href="{{ route('configuracoes.sms') }}" 
                   class="w-full bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors flex items-center justify-center">
                    <i class="fas fa-cog mr-2"></i>
                    Configurar SMS
                </a>
            </div>
        </div>

        <!-- Email/SMTP -->
        <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center">
                        <div class="bg-blue-100 p-3 rounded-lg mr-3">
                            <i class="fas fa-envelope text-2xl text-blue-600"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Email / SMTP</h3>
                            <p class="text-sm text-gray-600">Configurar notificações email</p>
                        </div>
                    </div>
                    @if($configuracoes['email']['host'])
                        <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                    @else
                        <div class="w-3 h-3 bg-red-500 rounded-full"></div>
                    @endif
                </div>
                
                <div class="space-y-2 mb-4">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Status:</span>
                        <span class="font-medium text-{{ $configuracoes['email']['host'] ? 'green' : 'red' }}-600">
                            {{ $configuracoes['email']['host'] ? 'Configurado' : 'Não configurado' }}
                        </span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Servidor:</span>
                        <span class="font-medium">{{ $configuracoes['email']['host'] ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Email Ativo:</span>
                        <span class="font-medium text-{{ $configuracoes['email']['email_enabled'] ? 'green' : 'red' }}-600">
                            {{ $configuracoes['email']['email_enabled'] ? 'Sim' : 'Não' }}
                        </span>
                    </div>
                </div>
                
                <a href="{{ route('configuracoes.email') }}" 
                   class="w-full bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors flex items-center justify-center">
                    <i class="fas fa-cog mr-2"></i>
                    Configurar Email
                </a>
            </div>
        </div>

        <!-- Alertas -->
        <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center">
                        <div class="bg-red-100 p-3 rounded-lg mr-3">
                            <i class="fas fa-exclamation-triangle text-2xl text-red-600"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Alertas</h3>
                            <p class="text-sm text-gray-600">Configurar sistema de alertas</p>
                        </div>
                    </div>
                    <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                </div>
                
                <div class="space-y-2 mb-4">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Escalação:</span>
                        <span class="font-medium text-{{ $configuracoes['alertas']['escalacao_enabled'] ? 'green' : 'red' }}-600">
                            {{ $configuracoes['alertas']['escalacao_enabled'] ? 'Ativa' : 'Inativa' }}
                        </span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Tempo Escalação:</span>
                        <span class="font-medium">{{ $configuracoes['alertas']['tempo_escalacao'] }} min</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Relatório:</span>
                        <span class="font-medium">{{ $configuracoes['alertas']['horario_relatorio'] }}</span>
                    </div>
                </div>
                
                <a href="{{ route('configuracoes.alertas') }}" 
                   class="w-full bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 transition-colors flex items-center justify-center">
                    <i class="fas fa-cog mr-2"></i>
                    Configurar Alertas
                </a>
            </div>
        </div>

        <!-- Sistema -->
        <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center">
                        <div class="bg-gray-100 p-3 rounded-lg mr-3">
                            <i class="fas fa-server text-2xl text-gray-600"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Sistema</h3>
                            <p class="text-sm text-gray-600">Configurações gerais</p>
                        </div>
                    </div>
                    <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                </div>
                
                <div class="space-y-2 mb-4">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Nome:</span>
                        <span class="font-medium">{{ $configuracoes['geral']['nome_sistema'] }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Timezone:</span>
                        <span class="font-medium">{{ $configuracoes['geral']['timezone'] }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Debug:</span>
                        <span class="font-medium text-{{ $configuracoes['geral']['debug_mode'] ? 'yellow' : 'green' }}-600">
                            {{ $configuracoes['geral']['debug_mode'] ? 'Ativo' : 'Inativo' }}
                        </span>
                    </div>
                </div>
                
                <a href="{{ route('configuracoes.sistema') }}" 
                   class="w-full bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 transition-colors flex items-center justify-center">
                    <i class="fas fa-cog mr-2"></i>
                    Configurar Sistema
                </a>
            </div>
        </div>

        <!-- Notificações -->
        <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center">
                        <div class="bg-purple-100 p-3 rounded-lg mr-3">
                            <i class="fas fa-bell text-2xl text-purple-600"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Notificações</h3>
                            <p class="text-sm text-gray-600">Configurações pessoais</p>
                        </div>
                    </div>
                    <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                </div>
                
                <div class="space-y-2 mb-4">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Enviadas Hoje:</span>
                        <span class="font-medium">{{ $stats['notificacoes_hoje'] }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Status:</span>
                        <span class="font-medium text-green-600">Ativo</span>
                    </div>
                </div>
                
                <a href="{{ route('notifications.config') }}" 
                   class="w-full bg-purple-600 text-white px-4 py-2 rounded-md hover:bg-purple-700 transition-colors flex items-center justify-center">
                    <i class="fas fa-user-cog mr-2"></i>
                    Config. Pessoais
                </a>
            </div>
        </div>

        <!-- Informações do Sistema -->
        <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center">
                        <div class="bg-indigo-100 p-3 rounded-lg mr-3">
                            <i class="fas fa-info-circle text-2xl text-indigo-600"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900">Informações</h3>
                            <p class="text-sm text-gray-600">Dados do sistema</p>
                        </div>
                    </div>
                    <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                </div>
                
                <div class="space-y-2 mb-4">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Ambiente:</span>
                        <span class="font-medium">Produção</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Uptime:</span>
                        <span class="font-medium">{{ $stats['uptime'] }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Status:</span>
                        <span class="font-medium text-green-600">Operacional</span>
                    </div>
                </div>
                
                <a href="{{ route('configuracoes.info') }}" 
                   class="w-full bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 transition-colors flex items-center justify-center">
                    <i class="fas fa-info mr-2"></i>
                    Ver Informações
                </a>
            </div>
        </div>
    </div>

    <!-- Ações Rápidas -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">
            <i class="fas fa-bolt mr-2 text-yellow-600"></i>
            Ações Rápidas do Sistema
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <form method="POST" action="{{ route('configuracoes.sistema.clear-caches') }}">
                @csrf
                <button type="submit" class="w-full flex items-center justify-center p-4 border border-yellow-300 bg-yellow-50 text-yellow-700 rounded-lg hover:bg-yellow-100 transition-colors">
                    <i class="fas fa-broom mr-2"></i>
                    Limpar Caches
                </button>
            </form>
            
            <a href="{{ route('notifications.dashboard') }}" class="flex items-center justify-center p-4 border border-purple-300 bg-purple-50 text-purple-700 rounded-lg hover:bg-purple-100 transition-colors">
                <i class="fas fa-chart-bar mr-2"></i>
                Dashboard Notific.
            </a>
            
            <a href="{{ route('alertas.index') }}" class="flex items-center justify-center p-4 border border-red-300 bg-red-50 text-red-700 rounded-lg hover:bg-red-100 transition-colors">
                <i class="fas fa-exclamation-triangle mr-2"></i>
                Gerir Alertas
            </a>
            
            <a href="{{ route('importacao.index') }}" class="flex items-center justify-center p-4 border border-green-300 bg-green-50 text-green-700 rounded-lg hover:bg-green-100 transition-colors">
                <i class="fas fa-upload mr-2"></i>
                Importar Dados
            </a>
        </div>
    </div>
</div>
@endsection