@extends('layouts.app')

@section('title', 'Importar Dados')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-upload mr-3 text-green-600"></i>
                    Importar Dados Excel
                </h1>
                <p class="text-gray-600 mt-2">Importe dados de barragens, estações e leituras através de arquivos Excel</p>
            </div>
            <div class="text-sm text-gray-500">
                Formatos suportados: .xlsx, .xls
            </div>
        </div>
    </div>

    <!-- Success/Error Messages -->
    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg">
            <div class="flex items-center">
                <i class="fas fa-check-circle mr-2"></i>
                <span>{{ session('success') }}</span>
            </div>
            
            @if(session('import_result'))
                @php $result = session('import_result') @endphp
                <div class="mt-3 text-sm">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div class="bg-white p-3 rounded">
                            <div class="text-green-600 font-medium">Sucessos</div>
                            <div class="text-2xl font-bold">{{ $result['success'] ?? 0 }}</div>
                        </div>
                        @if(($result['errors'] ?? 0) > 0)
                        <div class="bg-white p-3 rounded">
                            <div class="text-red-600 font-medium">Erros</div>
                            <div class="text-2xl font-bold">{{ $result['errors'] ?? 0 }}</div>
                        </div>
                        @endif
                        @if(($result['skipped'] ?? 0) > 0)
                        <div class="bg-white p-3 rounded">
                            <div class="text-yellow-600 font-medium">Ignorados</div>
                            <div class="text-2xl font-bold">{{ $result['skipped'] ?? 0 }}</div>
                        </div>
                        @endif
                    </div>
                </div>
            @endif
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg">
            <div class="flex items-center">
                <i class="fas fa-exclamation-triangle mr-2"></i>
                <span>{{ session('error') }}</span>
            </div>
        </div>
    @endif

    <!-- Excel Completo Import (Destaque) -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-gray-800 flex items-center">
                    <i class="fas fa-file-excel mr-3 text-green-600"></i>
                    Importar Excel Completo das Barragens
                </h2>
                <p class="text-gray-600 mt-2">Importe o arquivo "BARRAGENS ACT 8.8.xlsm" completo para gerar gráficos idênticos ao Excel original</p>
            </div>
            <div class="text-6xl text-gray-200">
                <i class="fas fa-chart-line"></i>
            </div>
        </div>

        <form action="{{ route('importacao.barragens-completo') }}" method="POST" enctype="multipart/form-data" class="mt-6">
            @csrf
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-file mr-1"></i>
                        Arquivo Excel Completo (.xlsm)
                    </label>
                    <input type="file" name="file" accept=".xlsx,.xls,.xlsm" required
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500">
                    <p class="text-xs text-gray-500 mt-1">
                        <i class="fas fa-info-circle mr-1"></i>
                        Processa automaticamente todas as abas: NAMPULA, NACALA, MUGICA, CHIPEMBE, LOCUMUE, MITUCUE
                    </p>
                </div>
                <div class="flex items-end">
                    <button type="submit" class="w-full bg-green-600 text-white font-bold px-6 py-3 rounded-md hover:bg-green-700 transition-colors flex items-center justify-center">
                        <i class="fas fa-magic mr-2"></i>
                        Importar & Gerar Gráficos
                    </button>
                </div>
            </div>
        </form>

        <div class="mt-4 text-xs text-gray-500">
            <i class="fas fa-lightbulb mr-1 text-green-600"></i>
            Esta opção processará automaticamente todas as barragens e suas leituras históricas para reproduzir os gráficos exatamente como no Excel original.
        </div>
    </div>

    <!-- Import Options -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        
        <!-- Barragens Import -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-dam mr-2 text-blue-600"></i>
                    Importar Barragens
                </h3>
            </div>
            <div class="p-6">
                <form action="{{ route('importacao.barragens') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Arquivo Excel</label>
                            <input type="file" name="file" accept=".xlsx,.xls" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <p class="text-xs text-gray-500 mt-1">Colunas esperadas: nome, codigo, provincia, distrito, latitude, longitude, etc.</p>
                        </div>
                        <button type="submit"
                                class="w-full text-white px-4 py-2 rounded-md transition-colors flex items-center justify-center"
                                style="background-color: #2563eb; border: 1px solid #2563eb; display: flex !important; visibility: visible !important; opacity: 1 !important;"
                                onmouseover="this.style.backgroundColor='#1d4ed8'"
                                onmouseout="this.style.backgroundColor='#2563eb'">
                            <i class="fas fa-upload mr-2"></i>
                            Importar Barragens
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Estações Import -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-satellite-dish mr-2 text-green-600"></i>
                    Importar Estações
                </h3>
            </div>
            <div class="p-6">
                <form action="{{ route('importacao.estacoes') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Arquivo Excel</label>
                            <input type="file" name="file" accept=".xlsx,.xls" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                            <p class="text-xs text-gray-500 mt-1">Colunas esperadas: nome, codigo, tipo, provincia, latitude, longitude, etc.</p>
                        </div>
                        <button type="submit"
                                class="w-full text-white px-4 py-2 rounded-md transition-colors flex items-center justify-center"
                                style="background-color: #16a34a; border: 1px solid #16a34a; display: flex !important; visibility: visible !important; opacity: 1 !important;"
                                onmouseover="this.style.backgroundColor='#15803d'"
                                onmouseout="this.style.backgroundColor='#16a34a'">
                            <i class="fas fa-upload mr-2"></i>
                            Importar Estações
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Leituras Import -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <i class="fas fa-chart-line mr-2 text-purple-600"></i>
                    Importar Leituras
                </h3>
            </div>
            <div class="p-6">
                <form action="{{ route('importacao.leituras') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Tipo de Leitura</label>
                            <select name="tipo" required 
                                    class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500">
                                <option value="">Selecione o tipo</option>
                                <option value="auto">Automática</option>
                                <option value="barragem">Barragem</option>
                                <option value="estacao">Estação</option>
                                <option value="pluviometrica">Pluviométrica</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Arquivo Excel</label>
                            <input type="file" name="file" accept=".xlsx,.xls" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500">
                            <p class="text-xs text-gray-500 mt-1">Colunas esperadas: data_leitura, hora_leitura, cota_actual, volume_actual, etc.</p>
                        </div>
                        <button type="submit"
                                class="w-full text-white px-4 py-2 rounded-md transition-colors flex items-center justify-center"
                                style="background-color: #7c3aed; border: 1px solid #7c3aed; display: flex !important; visibility: visible !important; opacity: 1 !important;"
                                onmouseover="this.style.backgroundColor='#6d28d9'"
                                onmouseout="this.style.backgroundColor='#7c3aed'">
                            <i class="fas fa-upload mr-2"></i>
                            Importar Leituras
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Instructions -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">
            <i class="fas fa-info-circle mr-2 text-blue-600"></i>
            Instruções de Importação
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div>
                <h4 class="font-medium text-blue-600 mb-2">Barragens</h4>
                <ul class="text-sm text-gray-600 space-y-1">
                    <li>• <strong>nome:</strong> Nome da barragem</li>
                    <li>• <strong>codigo:</strong> Código único (ex: SAC)</li>
                    <li>• <strong>provincia:</strong> Província</li>
                    <li>• <strong>distrito:</strong> Distrito</li>
                    <li>• <strong>latitude:</strong> Coordenada latitude</li>
                    <li>• <strong>longitude:</strong> Coordenada longitude</li>
                    <li>• <strong>cota_maxima:</strong> Cota máxima (m)</li>
                    <li>• <strong>volume_maximo:</strong> Volume máximo (m³)</li>
                    <li>• <strong>estado:</strong> activa/inactiva/manutencao</li>
                </ul>
            </div>
            
            <div>
                <h4 class="font-medium text-green-600 mb-2">Estações</h4>
                <ul class="text-sm text-gray-600 space-y-1">
                    <li>• <strong>nome:</strong> Nome da estação</li>
                    <li>• <strong>codigo:</strong> Código único (ex: E-127, P-332)</li>
                    <li>• <strong>tipo:</strong> hidrometrica/pluviometrica/meteorologica</li>
                    <li>• <strong>provincia:</strong> Província</li>
                    <li>• <strong>distrito:</strong> Distrito</li>
                    <li>• <strong>latitude:</strong> Coordenada latitude</li>
                    <li>• <strong>longitude:</strong> Coordenada longitude</li>
                    <li>• <strong>altitude:</strong> Altitude (m)</li>
                    <li>• <strong>estado:</strong> activa/inactiva/manutencao</li>
                </ul>
            </div>
            
            <div>
                <h4 class="font-medium text-purple-600 mb-2">Leituras (Formato SAC/E/P)</h4>
                <ul class="text-sm text-gray-600 space-y-1">
                    <li><strong>Barragens (SAC-xxxx.xls):</strong></li>
                    <li>• Data, NPA, NME, V.MORTO, Nível, Precipitação</li>
                    <li>• Cota, DESCARGAS, COTA, Níveis, V.TOTAL, V.UTIL</li>
                    <li>• CAUDAL DESCARREGADO, TOTAL %, UTIL %</li>
                    <li class="mt-2"><strong>Estações (E-xxx.xls):</strong></li>
                    <li>• Data, NPA, NME, V.MORTO, Nível, Precipitação, Cota</li>
                    <li class="mt-2"><strong>Pluviométricas (P-xxx.xls):</strong></li>
                    <li>• Data, Precipitação, Temperatura, Observações</li>
                </ul>
            </div>
        </div>

        <div class="mt-6 p-4 bg-yellow-50 border-l-4 border-yellow-400">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="fas fa-exclamation-triangle text-yellow-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-yellow-700">
                        <strong>Importante:</strong> Certifique-se de que os nomes das colunas no Excel correspondem exatamente aos nomes esperados. 
                        A primeira linha deve conter os cabeçalhos das colunas. Dados duplicados (baseados no código) serão ignorados.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Imports -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">
            <i class="fas fa-history mr-2 text-gray-600"></i>
            Histórico de Importações
        </h3>
        
        <div class="text-center py-8">
            <i class="fas fa-clock text-4xl text-gray-300 mb-4"></i>
            <p class="text-gray-500">Funcionalidade de histórico será implementada em breve</p>
        </div>
    </div>
</div>

<script>
// Debug para verificar se os botões estão sendo afetados por JavaScript
document.addEventListener('DOMContentLoaded', function() {
    console.log('Página de importação carregada');
    
    // Verificar se todos os botões de submit estão visíveis
    const submitButtons = document.querySelectorAll('button[type="submit"]');
    console.log('Botões de submit encontrados:', submitButtons.length);
    
    submitButtons.forEach((button, index) => {
        console.log(`Botão ${index + 1}:`, {
            display: getComputedStyle(button).display,
            visibility: getComputedStyle(button).visibility,
            opacity: getComputedStyle(button).opacity,
            text: button.textContent.trim()
        });
        
        // Garantir que o botão está visível
        button.style.display = 'flex';
        button.style.visibility = 'visible';
        button.style.opacity = '1';
    });
    
    // Verificar se há CSS conflitante
    const allButtons = document.querySelectorAll('button');
    allButtons.forEach(button => {
        const styles = getComputedStyle(button);
        if (styles.display === 'none' || styles.visibility === 'hidden' || styles.opacity === '0') {
            console.warn('Botão oculto encontrado:', button, {
                display: styles.display,
                visibility: styles.visibility,
                opacity: styles.opacity
            });
        }
    });
});

// Função para forçar visibilidade dos botões
function forceButtonVisibility() {
    const buttons = document.querySelectorAll('button[type="submit"]');
    buttons.forEach(button => {
        button.style.display = 'flex !important';
        button.style.visibility = 'visible !important';
        button.style.opacity = '1 !important';
        button.style.zIndex = '999';
    });
    console.log('Visibilidade dos botões forçada');
}

// Executar a função após 1 segundo para garantir que todos os estilos foram aplicados
setTimeout(forceButtonVisibility, 1000);
</script>

@endsection