<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Sistema Hidrológico') - {{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <!-- Sidebar CSS -->
    <style>
        /* Garantir largura fixa do sidebar */
        #sidebar {
            width: 16rem !important;
            min-width: 16rem !important;
            max-width: 16rem !important;
            flex-shrink: 0 !important;
        }

        /* Evitar quebra de linha nos itens do menu */
        #sidebar button span,
        #sidebar a span {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        /* Garantir que títulos longos não quebrem */
        #sidebar button .flex.items-center,
        #sidebar a .flex.items-center {
            white-space: nowrap;
            min-width: 0;
        }

        #sidebar button .flex.items-center span,
        #sidebar a .flex.items-center span {
            white-space: nowrap;
            text-overflow: ellipsis;
            overflow: hidden;
            max-width: 180px; /* Limitar largura do texto */
        }

        /* Garantir que os itens do menu tenham largura adequada */
        #sidebar .space-y-1 > button,
        #sidebar .space-y-1 > a {
            min-height: 48px;
        }

        /* Container principal com largura controlada */
        .main-container {
            display: flex;
            min-height: 100vh;
        }

        .main-content {
            flex: 1;
            min-width: 0; /* Permite que o conteúdo se ajuste */
            overflow-x: auto; /* Adiciona scroll horizontal se necessário */
            width: calc(100% - 16rem); /* Subtrair largura do sidebar */
        }

        /* Media queries para responsividade */
        @media (max-width: 1024px) {
            #sidebar {
                position: fixed !important;
                z-index: 50 !important;
            }

            .main-content {
                width: 100% !important;
            }
        }

        /* Garantir que tabelas grandes não afetem o sidebar */
        .main-content table {
            min-width: 100%;
            table-layout: auto;
        }

        .main-content .overflow-x-auto {
            max-width: 100%;
        }
    </style>
</head>
<body class="font-sans antialiased bg-gray-50">
    <div class="main-container">
        <!-- Sidebar -->
        <aside id="sidebar" class="w-64 min-w-64 bg-blue-900 text-white transform transition-transform duration-300 ease-in-out lg:translate-x-0 -translate-x-full fixed lg:static h-screen z-50 flex flex-col flex-shrink-0">
            <!-- Header -->
            <div class="flex items-center justify-center h-16 border-b border-blue-800 flex-shrink-0">
                <h1 class="text-xl font-bold">
                    <i class="fas fa-water mr-2"></i>
                    Sistema Hidrológico
                </h1>
            </div>
            
            <!-- Navigation - Scrollable -->
            <nav class="flex-1 overflow-y-auto">
                <div class="px-4 py-6 space-y-2">
                    <!-- Dashboard -->
                    <a href="{{ route('dashboard') }}" 
                       class="flex items-center px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('dashboard') ? 'bg-blue-800' : '' }}">
                        <i class="fas fa-chart-line mr-3"></i>
                        Dashboard
                    </a>

                    <!-- Bacias Hidrográficas -->
                    <div class="space-y-1">
                        <button onclick="toggleSubmenu('bacias')" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('bacias.*') ? 'bg-blue-800' : '' }}">
                            <div class="flex items-center">
                                <i class="fas fa-water mr-3"></i>
                                <span>Bacias</span>
                            </div>
                            <i class="fas fa-chevron-down transform transition-transform" id="bacias-arrow"></i>
                        </button>
                        <div id="bacias-submenu" class="ml-4 space-y-1 hidden">
                            <a href="{{ route('bacias.index') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('bacias.index') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-list mr-3 text-sm"></i>
                                Listar Bacias
                            </a>
                            <a href="{{ route('bacias.create') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('bacias.create') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-plus mr-3 text-sm"></i>
                                Nova Bacia
                            </a>
                        </div>
                    </div>

                    <!-- Barragens -->
                    <div class="space-y-1">
                        <button onclick="toggleSubmenu('barragens')"
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('barragens.*') ? 'bg-blue-800' : '' }}">
                            <div class="flex items-center">
                                <i class="fas fa-water mr-3"></i>
                                <span>Barragens</span>
                            </div>
                            <i class="fas fa-chevron-down transform transition-transform" id="barragens-arrow"></i>
                        </button>
                        <div id="barragens-submenu" class="ml-4 space-y-1 hidden">
                            <a href="{{ route('barragens.index') }}"
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('barragens.index') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-list mr-3 text-sm"></i>
                                Listar Barragens
                            </a>
                            <a href="{{ route('barragens.create') }}"
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('barragens.create') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-plus mr-3 text-sm"></i>
                                Nova Barragem
                            </a>
                        </div>
                    </div>

                    <!-- Estações -->
                    <div class="space-y-1">
                        <button onclick="toggleSubmenu('estacoes')" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('estacoes.*') ? 'bg-blue-800' : '' }}">
                            <div class="flex items-center">
                                <i class="fas fa-satellite-dish mr-3"></i>
                                <span>Estações</span>
                            </div>
                            <i class="fas fa-chevron-down transform transition-transform" id="estacoes-arrow"></i>
                        </button>
                        <div id="estacoes-submenu" class="ml-4 space-y-1 hidden">
                            <a href="{{ route('estacoes.index') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('estacoes.index') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-list mr-3 text-sm"></i>
                                Listar Estações
                            </a>
                            <a href="{{ route('estacoes.create') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('estacoes.create') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-plus mr-3 text-sm"></i>
                                Nova Estação
                            </a>
                        </div>
                    </div>

                    <!-- Alertas -->
                    <a href="{{ route('alertas.index') }}" 
                       class="flex items-center px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('alertas.*') ? 'bg-blue-800' : '' }}">
                        <i class="fas fa-exclamation-triangle mr-3"></i>
                        Alertas
                    </a>

                    <!-- Notificações -->
                    <div class="space-y-1">
                        <button onclick="toggleSubmenu('notifications')" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('notifications.*') ? 'bg-blue-800' : '' }}">
                            <div class="flex items-center">
                                <i class="fas fa-bell mr-3"></i>
                                <span>Notificações</span>
                            </div>
                            <i class="fas fa-chevron-down transform transition-transform" id="notifications-arrow"></i>
                        </button>
                        <div id="notifications-submenu" class="ml-4 space-y-1 hidden">
                            <a href="{{ route('notifications.config') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('notifications.config') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-cog mr-3 text-sm"></i>
                                Configurações
                            </a>
                            <a href="{{ route('notifications.historico') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('notifications.historico') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-history mr-3 text-sm"></i>
                                Histórico
                            </a>
                        </div>
                    </div>

                    <!-- Boletins -->
                    <div class="space-y-1 mt-4">
                        <button onclick="toggleSubmenu('boletins')" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('boletins.*') ? 'bg-blue-800' : '' }}">
                            <div class="flex items-center">
                                <i class="fas fa-file-alt mr-3"></i>
                                <span>Boletins</span>
                            </div>
                            <i class="fas fa-chevron-down transform transition-transform" id="boletins-arrow"></i>
                        </button>
                        <div id="boletins-submenu" class="ml-4 space-y-1 hidden">
                            <a href="{{ route('boletins.index') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('boletins.index') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-list mr-3 text-sm"></i>
                                Listar Boletins
                            </a>
                            <a href="{{ route('boletins.create') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('boletins.create') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-plus mr-3 text-sm"></i>
                                Novo Boletim
                            </a>
                        </div>
                    </div>

                    <!-- Gráficos -->
                    <div class="space-y-1 mt-4">
                        <button onclick="toggleSubmenu('graficos')" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('charts.*') ? 'bg-blue-800' : '' }}">
                            <div class="flex items-center">
                                <i class="fas fa-chart-line mr-3"></i>
                                <span>Gráficos</span>
                            </div>
                            <i class="fas fa-chevron-down transform transition-transform" id="graficos-arrow"></i>
                        </button>
                        <div id="graficos-submenu" class="ml-4 space-y-1 hidden">
                            <a href="{{ route('charts.index') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('charts.index') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-home mr-3 text-sm"></i>
                                Menu Principal
                            </a>
                            <a href="{{ route('charts.barragens') }}"
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('charts.barragens*') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-water mr-3 text-sm"></i>
                                Barragens
                            </a>
                            <a href="{{ route('graficos-barragem') }}"
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('graficos-barragem') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-chart-area mr-3 text-sm"></i>
                                Dashboard Excel
                            </a>
                            <a href="{{ route('charts.estacoes') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('charts.estacoes*') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-satellite-dish mr-3 text-sm"></i>
                                Estações
                            </a>
                            <a href="{{ route('charts.regional') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('charts.regional') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-globe-africa mr-3 text-sm"></i>
                                Regional
                            </a>
                        </div>
                    </div>

                    <!-- Importação -->
                    <div class="mt-4">
                        <a href="{{ route('importacao.index') }}" 
                           class="flex items-center px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('importacao.*') ? 'bg-blue-800' : '' }}">
                            <i class="fas fa-upload mr-3"></i>
                            Importar Dados
                        </a>
                    </div>

                    <!-- Configurações -->
                    <div class="space-y-1 mt-4">
                        <button onclick="toggleSubmenu('configuracoes')" 
                                class="w-full flex items-center justify-between px-4 py-3 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('configuracoes.*') ? 'bg-blue-800' : '' }}">
                            <div class="flex items-center">
                                <i class="fas fa-cogs mr-3"></i>
                                <span>Configurações</span>
                            </div>
                            <i class="fas fa-chevron-down transform transition-transform" id="configuracoes-arrow"></i>
                        </button>
                        <div id="configuracoes-submenu" class="ml-4 space-y-1 hidden">
                            <a href="{{ route('configuracoes.index') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('configuracoes.index') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-tachometer-alt mr-3 text-sm"></i>
                                Visão Geral
                            </a>
                            <a href="{{ route('configuracoes.sms') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('configuracoes.sms') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-sms mr-3 text-sm"></i>
                                SMS / Twilio
                            </a>
                            <a href="{{ route('configuracoes.email') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('configuracoes.email') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-envelope mr-3 text-sm"></i>
                                Email / SMTP
                            </a>
                            <a href="{{ route('configuracoes.alertas') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('configuracoes.alertas') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-exclamation-triangle mr-3 text-sm"></i>
                                Alertas
                            </a>
                            <a href="{{ route('configuracoes.sistema') }}"
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('configuracoes.sistema') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-server mr-3 text-sm"></i>
                                Sistema
                            </a>
                            <a href="{{ route('settings.index') }}"
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('settings.*') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-building mr-3 text-sm"></i>
                                Organização
                            </a>
                            <a href="{{ route('configuracoes.info') }}" 
                               class="flex items-center px-4 py-2 rounded-lg hover:bg-blue-800 transition-colors {{ request()->routeIs('configuracoes.info') ? 'bg-blue-700' : '' }}">
                                <i class="fas fa-info-circle mr-3 text-sm"></i>
                                Informações
                            </a>
                        </div>
                    </div>
                </div>
            </nav>

            <!-- Logout Button - Fixed at bottom -->
            <div class="border-t border-blue-800 flex-shrink-0 p-4">
                <form method="POST" action="{{ route('logout') }}" class="w-full">
                    @csrf
                    <button type="submit" class="w-full flex items-center justify-center px-4 py-2 bg-blue-800 hover:bg-blue-700 text-white text-sm rounded-lg transition-colors">
                        <i class="fas fa-sign-out-alt mr-2"></i>
                        Sair do Sistema
                    </button>
                </form>
            </div>
        </aside>

        <!-- Main Content -->
        <div class="main-content flex-1 flex flex-col lg:ml-0">
            <!-- Top Bar -->
            <header class="bg-white shadow-sm border-b border-gray-200">
                <div class="flex items-center justify-between px-6 py-4">
                    <div class="flex items-center">
                        <button id="sidebar-toggle" class="lg:hidden text-gray-600 hover:text-gray-900">
                            <i class="fas fa-bars text-xl"></i>
                        </button>
                        <h2 class="ml-4 text-xl font-semibold text-gray-800">
                            @yield('title', 'Sistema Hidrológico')
                        </h2>
                    </div>
                    
                    <div class="flex items-center space-x-4">
                        <!-- Notifications -->
                        <button class="relative text-gray-600 hover:text-gray-900">
                            <i class="fas fa-bell text-xl"></i>
                            <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center">3</span>
                        </button>
                        
                        <!-- User Dropdown -->
                        <div class="relative">
                            <button onclick="toggleProfileDropdown()" class="flex items-center text-gray-600 hover:text-gray-900 focus:outline-none">
                                <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center">
                                    <i class="fas fa-user text-sm text-white"></i>
                                </div>
                                <div class="ml-3 hidden md:block text-left">
                                    <div class="text-sm font-medium text-gray-900">{{ Auth::user()->name ?? 'Administrador Sistema' }}</div>
                                    <div class="text-xs text-gray-500">{{ Auth::user()->cargo ?? 'Administrador do Sistema' }}</div>
                                </div>
                                <i class="fas fa-chevron-down ml-2 text-xs transform transition-transform" id="profile-arrow"></i>
                            </button>
                            
                            <!-- Dropdown Menu -->
                            <div id="profile-dropdown" class="absolute right-0 mt-2 w-56 bg-white rounded-lg shadow-lg border border-gray-200 py-2 z-50 hidden">
                                <div class="px-4 py-3 border-b border-gray-100">
                                    <div class="text-sm font-medium text-gray-900">{{ Auth::user()->name ?? 'Administrador Sistema' }}</div>
                                    <div class="text-xs text-gray-500">{{ Auth::user()->email ?? 'admin@sistema.com' }}</div>
                                    <div class="text-xs text-gray-500">{{ Auth::user()->cargo ?? 'Administrador do Sistema' }}</div>
                                </div>
                                <a href="#" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">
                                    <i class="fas fa-user-cog mr-3 text-gray-400"></i>
                                    Meu Perfil
                                </a>
                                <a href="#" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">
                                    <i class="fas fa-cog mr-3 text-gray-400"></i>
                                    Configurações
                                </a>
                                <div class="border-t border-gray-100 mt-2 pt-2">
                                    <form method="POST" action="{{ route('logout') }}">
                                        @csrf
                                        <button type="submit" class="flex items-center w-full px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">
                                            <i class="fas fa-sign-out-alt mr-3 text-gray-400"></i>
                                            Sair do Sistema
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 p-6">
                @yield('content')
            </main>
        </div>
    </div>

    <!-- Mobile Sidebar Overlay -->
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 lg:hidden hidden"></div>

    <script>
        // Sidebar toggle for mobile
        document.getElementById('sidebar-toggle').addEventListener('click', function() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            
            sidebar.classList.toggle('-translate-x-full');
            overlay.classList.toggle('hidden');
        });

        // Close sidebar when clicking overlay
        document.getElementById('sidebar-overlay').addEventListener('click', function() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        });

        // Submenu toggle function
        function toggleSubmenu(menuName) {
            const submenu = document.getElementById(menuName + '-submenu');
            const arrow = document.getElementById(menuName + '-arrow');

            if (submenu.classList.contains('hidden')) {
                submenu.classList.remove('hidden');
                arrow.classList.add('rotate-180');
            } else {
                submenu.classList.add('hidden');
                arrow.classList.remove('rotate-180');
            }
        }

        // Profile dropdown toggle function
        function toggleProfileDropdown() {
            const dropdown = document.getElementById('profile-dropdown');
            const arrow = document.getElementById('profile-arrow');
            
            if (dropdown.classList.contains('hidden')) {
                dropdown.classList.remove('hidden');
                arrow.classList.add('rotate-180');
            } else {
                dropdown.classList.add('hidden');
                arrow.classList.remove('rotate-180');
            }
        }

        // Close dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const dropdown = document.getElementById('profile-dropdown');
            const button = event.target.closest('button[onclick="toggleProfileDropdown()"]');
            
            if (!button && !dropdown.contains(event.target)) {
                dropdown.classList.add('hidden');
                document.getElementById('profile-arrow').classList.remove('rotate-180');
            }
        });

        // Auto-open submenu if current page is within that section
        document.addEventListener('DOMContentLoaded', function() {
            const currentPath = window.location.pathname;

            // Check if we're on a bacias page
            if (currentPath.includes('/bacias')) {
                toggleSubmenu('bacias');
            }
            // Check if we're on a barragens page
            else if (currentPath.includes('/barragens')) {
                toggleSubmenu('barragens');
            }
            // Check if we're on an estacoes page
            else if (currentPath.includes('/estacoes')) {
                toggleSubmenu('estacoes');
            }
            // Check if we're on a boletins page
            else if (currentPath.includes('/boletins')) {
                toggleSubmenu('boletins');
            }
            // Check if we're on a charts page
            else if (currentPath.includes('/charts')) {
                toggleSubmenu('graficos');
            }
        });
    </script>
</body>
</html>
