import openpyxl
from openpyxl.utils import get_column_letter

def analyze_chart_sheet():
    wb = openpyxl.load_workbook('ficheiros/Cópia de BARRAGENS ACT 8.8.xlsm', data_only=False)
    ws = wb['GRAFICOS DE BARRAGEM']

    print('📈 ANÁLISE DETALHADA DA FOLHA "GRAFICOS DE BARRAGEM"')
    print('=' * 70)

    # Informações básicas
    print(f'📐 Dimensões: {ws.max_row} linhas x {ws.max_column} colunas')

    # Analisar dados na folha
    print()
    print('📊 DADOS NA FOLHA:')
    print('-' * 30)

    # Mostrar algumas linhas para entender a estrutura
    for row in range(1, min(15, ws.max_row + 1)):
        row_data = []
        for col in range(1, min(10, ws.max_column + 1)):
            cell = ws.cell(row=row, column=col)
            value = cell.value
            if value is not None:
                if str(value).startswith('='):
                    row_data.append(f'FÓRMULA: {value}')
                else:
                    row_data.append(str(value))
            else:
                row_data.append('vazio')

        if any(item != 'vazio' for item in row_data):
            print(f'Linha {row}: {" | ".join(row_data[:5])}...')

    # Analisar gráficos em detalhe
    print()
    print('📈 ANÁLISE DOS GRÁFICOS:')
    print('-' * 40)

    if hasattr(ws, '_charts') and ws._charts:
        for i, chart in enumerate(ws._charts, 1):
            print(f'')
            print(f'🔵 GRÁFICO {i}:')
            print(f'   Tipo: {type(chart).__name__}')

            # Posição do gráfico
            if hasattr(chart, 'anchor'):
                print(f'   Posição: {chart.anchor}')

            # Título do gráfico
            if hasattr(chart, 'title') and chart.title:
                try:
                    titulo = chart.title.tx.rich.p[0].r.t if hasattr(chart.title.tx, 'rich') else 'Sem título'
                    print(f'   Título: {titulo}')
                except:
                    print('   Título: Não consegui extrair')

            # Séries de dados
            if hasattr(chart, 'series'):
                print(f'   Número de séries: {len(chart.series)}')
                for j, serie in enumerate(chart.series):
                    print(f'      Série {j+1}:')
                    if hasattr(serie, 'val') and serie.val:
                        try:
                            range_ref = serie.val.strRef.f if hasattr(serie.val, 'strRef') else 'Range não identificado'
                            print(f'         Dados: {range_ref}')
                        except:
                            print('         Dados: Não consegui extrair')
    else:
        print('Nenhum gráfico encontrado na folha.')

if __name__ == "__main__":
    try:
        analyze_chart_sheet()
    except Exception as e:
        print(f'❌ Erro: {e}')
        import traceback
        traceback.print_exc()
