<?php

namespace App\Console\Commands;

use App\Services\NotificationService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class EnviarRelatorioDiario extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'alertas:relatorio-diario {--force : Enviar relatório mesmo se não for horário configurado}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Enviar relatório diário de alertas por SMS para usuários configurados';

    /**
     * Execute the console command.
     */
    public function handle(NotificationService $notificationService)
    {
        $this->info('Iniciando envio do relatório diário de alertas...');

        try {
            // Verificar se é o horário configurado (a menos que seja forçado)
            if (!$this->option('force')) {
                $horarioAtual = now()->format('H:i');
                $horarioConfigurado = config('services.notifications.daily_report_time', '08:00');
                
                if ($horarioAtual !== $horarioConfigurado) {
                    $this->warn("Não é o horário configurado para envio ({$horarioConfigurado}). Use --force para enviar mesmo assim.");
                    return Command::SUCCESS;
                }
            }

            // Enviar relatórios
            $notificationService->enviarRelatorioDiario();
            
            $this->info('Relatório diário enviado com sucesso!');
            Log::info('Relatório diário de alertas enviado com sucesso');
            
            return Command::SUCCESS;
            
        } catch (\Exception $e) {
            $this->error('Erro ao enviar relatório diário: ' . $e->getMessage());
            Log::error('Erro ao enviar relatório diário de alertas', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            
            return Command::FAILURE;
        }
    }
}