<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\IOFactory;
use PhpOffice\PhpWord\Shared\Html;
use PhpOffice\PhpWord\Style\Font;

class DocumentacaoController extends Controller
{
    public function downloadEstruturaDados()
    {
        $phpWord = new PhpWord();

        // Configurar estilos
        $phpWord->addTitleStyle(1, ['bold' => true, 'size' => 16, 'color' => '0066CC'], ['alignment' => 'center']);
        $phpWord->addTitleStyle(2, ['bold' => true, 'size' => 14, 'color' => '0066CC']);
        $phpWord->addTitleStyle(3, ['bold' => true, 'size' => 12]);

        $phpWord->setDefaultFontName('Arial');
        $phpWord->setDefaultFontSize(11);

        $section = $phpWord->addSection([
            'marginTop' => 1440,
            'marginBottom' => 1440,
            'marginLeft' => 1440,
            'marginRight' => 1440,
        ]);

        // Cabeçalho
        $section->addTitle('ESTRUTURA DE DADOS DO SISTEMA SNIRH', 1);
        $section->addText('Sistema Nacional de Informação de Recursos Hídricos', ['bold' => true], ['alignment' => 'center']);
        $section->addText('ARA Norte, IP - Administração Regional de Águas do Norte', [], ['alignment' => 'center']);
        $section->addText('Documento Técnico de Referência', ['italic' => true], ['alignment' => 'center']);
        $section->addTextBreak(2);

        // 1. INTRODUÇÃO
        $section->addTitle('1. INTRODUÇÃO', 2);
        $section->addText(
            'Este documento descreve a estrutura de dados do sistema SNIRH, explicando a diferença entre dados cadastrais (fixos) e dados de leituras (variáveis).'
        );
        $section->addTextBreak();

        // Nota importante
        $section->addText('Conceito Importante:', ['bold' => true, 'color' => '2196F3']);
        $section->addText('Os dados no sistema estão divididos em duas categorias:');
        $section->addListItem('Dados Cadastrais (Fixos): Informações de projeto/configuração, inseridas uma vez durante o registo inicial');
        $section->addListItem('Dados de Leituras (Variáveis): Medições operacionais do dia-a-dia, inseridas regularmente');
        $section->addTextBreak();

        // 2. BARRAGENS
        $section->addTitle('2. BARRAGENS', 2);

        // 2.1 Dados Cadastrais
        $section->addTitle('2.1 Dados Cadastrais (Fixos)', 3);
        $section->addText('Estes dados são inseridos no formulário de criação/edição da barragem e raramente precisam ser alterados.');
        $section->addTextBreak();

        // Tabela de dados fixos de barragens
        $tableStyle = [
            'borderSize' => 6,
            'borderColor' => 'CCCCCC',
            'cellMargin' => 80
        ];
        $phpWord->addTableStyle('TableStyle', $tableStyle);

        $table = $section->addTable('TableStyle');

        // Header
        $table->addRow();
        $table->addCell(2500, ['bgColor' => '0066CC'])->addText('Categoria', ['bold' => true, 'color' => 'FFFFFF']);
        $table->addCell(4500, ['bgColor' => '0066CC'])->addText('Campos', ['bold' => true, 'color' => 'FFFFFF']);
        $table->addCell(3000, ['bgColor' => '0066CC'])->addText('Descrição', ['bold' => true, 'color' => 'FFFFFF']);

        // Dados
        $dadosFixosBarragens = [
            ['Identificação', 'Nome, Código, Bacia Hidrográfica, Estado', 'Dados básicos de identificação'],
            ['Localização', 'Província, Distrito, Latitude, Longitude', 'Posição geográfica'],
            ['Cotas Técnicas', 'Cota Máxima, Cota Mínima, NPA, NME, NMC, Nível do Descargador', 'Níveis de referência do projeto'],
            ['Volumes', 'Volume Máximo, Volume Morto, Volume Útil, Capacidade Total', 'Capacidades de armazenamento'],
            ['Características Físicas', 'Área da Bacia, Área de Inundação, Altura, Comprimento da Crista', 'Dimensões físicas'],
            ['Classificação Técnica', 'Tipo de Barragem, Finalidade, Tipo de Descargador, Classe de Risco', 'Classificações técnicas'],
            ['Informações do Projeto', 'Ano de Construção, Projetista, Construtora, Telemetria', 'Dados históricos'],
        ];

        foreach ($dadosFixosBarragens as $row) {
            $table->addRow();
            $table->addCell(2500, ['bgColor' => 'E8F5E9'])->addText($row[0], ['bold' => true]);
            $table->addCell(4500, ['bgColor' => 'E8F5E9'])->addText($row[1]);
            $table->addCell(3000, ['bgColor' => 'E8F5E9'])->addText($row[2]);
        }

        $section->addTextBreak();

        // 2.2 Dados Variáveis
        $section->addTitle('2.2 Dados de Leituras (Variáveis)', 3);
        $section->addText('Estes dados são inseridos no formulário de leituras da barragem, geralmente de forma diária.');
        $section->addTextBreak();

        $table2 = $section->addTable('TableStyle');
        $table2->addRow();
        $table2->addCell(2500, ['bgColor' => '0066CC'])->addText('Campo', ['bold' => true, 'color' => 'FFFFFF']);
        $table2->addCell(2000, ['bgColor' => '0066CC'])->addText('Unidade', ['bold' => true, 'color' => 'FFFFFF']);
        $table2->addCell(2000, ['bgColor' => '0066CC'])->addText('Frequência', ['bold' => true, 'color' => 'FFFFFF']);
        $table2->addCell(3500, ['bgColor' => '0066CC'])->addText('Descrição', ['bold' => true, 'color' => 'FFFFFF']);

        $dadosVariaveisBarragens = [
            ['Data/Hora da Leitura', 'Data/Hora', 'Diário', 'Momento da leitura'],
            ['Cota Actual', 'metros (m)', 'Diário', 'Nível de água medido'],
            ['Volume Actual', 'Mm³', 'Diário', 'Volume armazenado (calculado)'],
            ['Percentagem de Enchimento', '%', 'Diário', 'Percentual de ocupação'],
            ['Caudal Afluente', 'm³/s', 'Diário', 'Água que entra'],
            ['Caudal Efluente', 'm³/s', 'Diário', 'Água que sai'],
            ['Precipitação', 'mm', 'Diário', 'Chuva registada'],
            ['Evaporação', 'mm', 'Diário', 'Perda por evaporação'],
        ];

        foreach ($dadosVariaveisBarragens as $row) {
            $table2->addRow();
            $table2->addCell(2500, ['bgColor' => 'FFF3E0'])->addText($row[0]);
            $table2->addCell(2000, ['bgColor' => 'FFF3E0'])->addText($row[1]);
            $table2->addCell(2000, ['bgColor' => 'FFF3E0'])->addText($row[2]);
            $table2->addCell(3500, ['bgColor' => 'FFF3E0'])->addText($row[3]);
        }

        $section->addTextBreak();

        // 3. ESTAÇÕES
        $section->addTitle('3. ESTAÇÕES DE MONITORAMENTO', 2);

        // 3.1 Dados Cadastrais
        $section->addTitle('3.1 Dados Cadastrais (Fixos)', 3);
        $section->addText('Estes dados são inseridos no formulário de criação/edição da estação.');
        $section->addTextBreak();

        $table3 = $section->addTable('TableStyle');
        $table3->addRow();
        $table3->addCell(2500, ['bgColor' => '0066CC'])->addText('Categoria', ['bold' => true, 'color' => 'FFFFFF']);
        $table3->addCell(4500, ['bgColor' => '0066CC'])->addText('Campos', ['bold' => true, 'color' => 'FFFFFF']);
        $table3->addCell(3000, ['bgColor' => '0066CC'])->addText('Descrição', ['bold' => true, 'color' => 'FFFFFF']);

        $dadosFixosEstacoes = [
            ['Identificação', 'Nome, Código, Tipo, Bacia Hidrográfica', 'Dados básicos'],
            ['Localização', 'Província, Distrito, Rio, Latitude, Longitude, Altitude', 'Posição geográfica'],
            ['Configuração Operacional', 'Data de Instalação, Equipamento, Frequência de Leitura, Estado', 'Parâmetros de funcionamento'],
            ['Níveis de Alerta', 'Nível de Alerta, Cota de Alerta', 'Limiares para avisos'],
            ['Configuração de Cotas', 'Tipo de Entrada, Tipo de Fórmula, Parâmetros A/B/C, Cota de Referência', 'Calibração para cálculo'],
        ];

        foreach ($dadosFixosEstacoes as $row) {
            $table3->addRow();
            $table3->addCell(2500, ['bgColor' => 'E8F5E9'])->addText($row[0], ['bold' => true]);
            $table3->addCell(4500, ['bgColor' => 'E8F5E9'])->addText($row[1]);
            $table3->addCell(3000, ['bgColor' => 'E8F5E9'])->addText($row[2]);
        }

        $section->addTextBreak();

        // 3.2 Tipos de Estações e Leituras
        $section->addTitle('3.2 Tipos de Estações e Suas Leituras', 3);
        $section->addTextBreak();

        $table4 = $section->addTable('TableStyle');
        $table4->addRow();
        $table4->addCell(2500, ['bgColor' => '0066CC'])->addText('Tipo de Estação', ['bold' => true, 'color' => 'FFFFFF']);
        $table4->addCell(5000, ['bgColor' => '0066CC'])->addText('Dados de Leitura (Variáveis)', ['bold' => true, 'color' => 'FFFFFF']);
        $table4->addCell(2500, ['bgColor' => '0066CC'])->addText('Frequência', ['bold' => true, 'color' => 'FFFFFF']);

        $tiposEstacoes = [
            ['Hidrométrica', 'Níveis às 6h, 9h, 12h, 15h, 18h; Cotas; Caudal', 'Diário (múltiplos horários)'],
            ['Pluviométrica', 'Precipitação (mm), Hora da leitura', 'Diário'],
            ['Meteorológica', 'Temperatura Máx/Mín, Humidade, Evaporação', 'Diário'],
            ['Evaporimétrica', 'Evaporação (mm), Temperatura da água', 'Diário'],
        ];

        foreach ($tiposEstacoes as $row) {
            $table4->addRow();
            $table4->addCell(2500, ['bgColor' => 'FFF3E0'])->addText($row[0], ['bold' => true]);
            $table4->addCell(5000, ['bgColor' => 'FFF3E0'])->addText($row[1]);
            $table4->addCell(2500, ['bgColor' => 'FFF3E0'])->addText($row[2]);
        }

        $section->addTextBreak();

        // 4. FLUXO DE TRABALHO
        $section->addTitle('4. FLUXO DE TRABALHO', 2);
        $section->addText('Processo de Utilização do Sistema:', ['bold' => true]);
        $section->addListItem('Cadastro Inicial (uma vez): Registar barragens e estações com todos os dados fixos', 0, null, null, null);
        $section->addListItem('Operação Diária: Inserir leituras (níveis, precipitação, caudais)', 0, null, null, null);
        $section->addListItem('Geração de Boletins: Sistema gera relatórios com base nos dados inseridos', 0, null, null, null);
        $section->addListItem('Análise: Sistema calcula tendências e gera alertas automaticamente', 0, null, null, null);
        $section->addTextBreak();

        // 5. RESUMO
        $section->addTitle('5. RESUMO VISUAL', 2);
        $section->addTextBreak();

        $table5 = $section->addTable('TableStyle');
        $table5->addRow();
        $table5->addCell(5000, ['bgColor' => 'E8F5E9'])->addText('DADOS FIXOS (Cadastro)', ['bold' => true, 'size' => 12]);
        $table5->addCell(5000, ['bgColor' => 'FFF3E0'])->addText('DADOS VARIÁVEIS (Leituras)', ['bold' => true, 'size' => 12]);

        $table5->addRow();
        $cell1 = $table5->addCell(5000, ['bgColor' => 'E8F5E9']);
        $cell1->addText('• Inseridos uma vez');
        $cell1->addText('• Definidos no projeto');
        $cell1->addText('• Raramente alterados');
        $cell1->addText('• Configurações e limites');

        $cell2 = $table5->addCell(5000, ['bgColor' => 'FFF3E0']);
        $cell2->addText('• Inseridos diariamente');
        $cell2->addText('• Medições operacionais');
        $cell2->addText('• Mudam constantemente');
        $cell2->addText('• Base para análises');

        $table5->addRow();
        $table5->addCell(5000, ['bgColor' => 'E8F5E9'])->addText('Exemplos: Volume Máximo, NPA, Altura da Barragem, Tipo de Estação', ['italic' => true]);
        $table5->addCell(5000, ['bgColor' => 'FFF3E0'])->addText('Exemplos: Cota Actual, Volume Actual, Precipitação do dia, Nível às 6h', ['italic' => true]);

        $section->addTextBreak(2);

        // Rodapé
        $section->addText('ARA Norte, IP', ['bold' => true], ['alignment' => 'center']);
        $section->addText('Sistema Nacional de Informação de Recursos Hídricos - SNIRH', [], ['alignment' => 'center']);
        $section->addText('Documento gerado em: ' . now()->format('d/m/Y'), ['italic' => true], ['alignment' => 'center']);

        // Salvar e fazer download
        $filename = 'Estrutura_Dados_SNIRH_' . now()->format('Y-m-d') . '.docx';
        $tempFile = storage_path('app/temp/' . $filename);

        // Criar diretório se não existir
        if (!file_exists(storage_path('app/temp'))) {
            mkdir(storage_path('app/temp'), 0755, true);
        }

        $objWriter = IOFactory::createWriter($phpWord, 'Word2007');
        $objWriter->save($tempFile);

        return response()->download($tempFile, $filename)->deleteFileAfterSend(true);
    }
}
