<?php

namespace App\Http\Controllers;

use App\Models\SystemSetting;
use Illuminate\Http\Request;

class SystemSettingsController extends Controller
{
    public function index()
    {
        $categories = [
            'general' => 'Configurações Gerais',
            'organization' => 'Organização',
            'contact' => 'Informações de Contacto',
            'bulletin' => 'Configurações de Boletins'
        ];

        $settings_by_category = [];
        foreach ($categories as $key => $label) {
            $settings_by_category[$key] = [
                'label' => $label,
                'settings' => SystemSetting::getByCategory($key)
            ];
        }

        return view('settings.index', compact('settings_by_category'));
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'settings' => 'required|array',
            'settings.*' => 'nullable|string|max:1000'
        ]);

        foreach ($validated['settings'] as $key => $value) {
            SystemSetting::set($key, $value);
        }

        return redirect()->route('settings.index')
            ->with('success', 'Configurações atualizadas com sucesso!');
    }
}
