<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Services\RegionalAccessService;
use Symfony\Component\HttpFoundation\Response;

/**
 * Middleware para partilhar contexto regional com todas as views
 */
class ShareRegionalContext
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($user = $request->user()) {
            $accessService = new RegionalAccessService($user);

            // Partilhar com views
            view()->share([
                'regionalAccess' => $accessService,
                'userDivisoes' => $user->divisoesAtivas()->with('divisao')->get(),
                'hasGlobalAccess' => $accessService->hasGlobalAccess(),
                'divisaoPrimaria' => $user->divisao_primaria,
            ]);

            // Disponibilizar no request
            $request->attributes->set('regionalAccess', $accessService);
        }

        return $next($request);
    }
}
