<?php
// app/Models/BaciaHidrografica.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BaciaHidrografica extends Model
{
    use HasFactory;

    protected $table = 'bacias_hidrograficas';

    protected $fillable = [
        'nome',
        'codigo',
        'area_km2',
        'comprimento_rio_principal',
        'provincias_abrangidas',
        'descricao',
        'divisao_administrativa_id',
        'area_jurisdicao_id',
        'coordenadas_geograficas',
    ];

    protected $casts = [
        'area_km2' => 'decimal:2',
        'comprimento_rio_principal' => 'decimal:2',
        'coordenadas_geograficas' => 'array',
        'provincias_abrangidas' => 'array',
    ];

    public function barragens()
    {
        return $this->hasMany(Barragem::class);
    }

    public function estacoes()
    {
        return $this->hasMany(Estacao::class);
    }

    public function divisaoAdministrativa()
    {
        return $this->belongsTo(DivisaoAdministrativa::class);
    }

    public function areaJurisdicao()
    {
        return $this->belongsTo(AreaJurisdicao::class);
    }

    public function getProvinciasList()
    {
        return is_array($this->provincias_abrangidas)
            ? $this->provincias_abrangidas
            : [];
    }
}
