<?php
// app/Models/CurvaDescarga.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CurvaDescarga extends Model
{
    use HasFactory;

    protected $table = 'curvas_descarga';

    protected $fillable = [
        'estacao_id',
        'nivel',
        'caudal',
        'data_calibracao',
        'ativo',
        'observacoes',
    ];

    protected $casts = [
        'nivel' => 'decimal:2',
        'caudal' => 'decimal:3',
        'data_calibracao' => 'date',
        'ativo' => 'boolean',
    ];

    public function estacao(): BelongsTo
    {
        return $this->belongsTo(Estacao::class);
    }

    public function ativar()
    {
        // Desativar outras curvas da mesma estação
        static::where('estacao_id', $this->estacao_id)
            ->where('id', '!=', $this->id)
            ->update(['ativo' => false]);
        
        $this->update(['ativo' => true]);
    }

    public function getIdadeCalibracaoAttribute()
    {
        return $this->data_calibracao->diffInDays(now());
    }

    public function precisaRecalibracao()
    {
        return $this->getIdadeCalibracaoAttribute() > 365; // Mais de 1 ano
    }
}