<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MetaisPesados extends Model
{
    use HasFactory;

    protected $table = 'metais_pesados';

    protected $fillable = [
        'coleta_id',
        'ferro',
        'chumbo',
        'cadmio',
        'zinco',
        'cobre',
        'arsenio',
        'mercurio',
    ];

    protected $casts = [
        'ferro' => 'decimal:5',
        'chumbo' => 'decimal:5',
        'cadmio' => 'decimal:6',
        'zinco' => 'decimal:5',
        'cobre' => 'decimal:5',
        'arsenio' => 'decimal:5',
        'mercurio' => 'decimal:5',
    ];

    public function coleta(): BelongsTo
    {
        return $this->belongsTo(ColetaQA::class, 'coleta_id');
    }
}
