<?php
// routes/web.php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\BarragemController;
use App\Http\Controllers\EstacaoController;
use App\Http\Controllers\BoletimController;
use App\Http\Controllers\AlertaController;
use App\Http\Controllers\ImportacaoController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

Route::get('/', function () {
    return redirect('/dashboard');
});

Route::middleware('auth')->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Profile
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    // Barragens
    Route::prefix('barragens')->name('barragens.')->group(function () {
        Route::get('/', [BarragemController::class, 'index'])->name('index');
        Route::get('/create', [BarragemController::class, 'create'])->name('create');
        Route::post('/', [BarragemController::class, 'store'])->name('store');
        Route::get('/{barragem}', [BarragemController::class, 'show'])->name('show');
        Route::get('/{barragem}/edit', [BarragemController::class, 'edit'])->name('edit');
        Route::put('/{barragem}', [BarragemController::class, 'update'])->name('update');
        Route::delete('/{barragem}', [BarragemController::class, 'destroy'])->name('destroy');
        
        // Leituras
        Route::get('/{barragem}/leituras', [BarragemController::class, 'leituras'])->name('leituras');
        Route::post('/{barragem}/leituras', [BarragemController::class, 'storeLeitura'])->name('leituras.store');
        Route::get('/{barragem}/leituras/{leitura}/edit', [BarragemController::class, 'editLeitura'])->name('leituras.edit');
        Route::put('/{barragem}/leituras/{leitura}', [BarragemController::class, 'updateLeitura'])->name('leituras.update');
        Route::post('/{barragem}/leituras/{leitura}/validate', [BarragemController::class, 'validateLeitura'])->name('leituras.validate');
    });
    
    // Estações
    Route::prefix('estacoes')->name('estacoes.')->group(function () {
        Route::get('/', [EstacaoController::class, 'index'])->name('index');
        Route::get('/create', [EstacaoController::class, 'create'])->name('create');
        Route::post('/', [EstacaoController::class, 'store'])->name('store');
        Route::get('/{estacao}', [EstacaoController::class, 'show'])->name('show');
        Route::get('/{estacao}/edit', [EstacaoController::class, 'edit'])->name('edit');
        Route::put('/{estacao}', [EstacaoController::class, 'update'])->name('update');
        Route::delete('/{estacao}', [EstacaoController::class, 'destroy'])->name('destroy');
        
        // Leituras
        Route::get('/{estacao}/leituras', [EstacaoController::class, 'leituras'])->name('leituras');
        Route::post('/{estacao}/leituras', [EstacaoController::class, 'storeLeitura'])->name('leituras.store');
        Route::get('/{estacao}/leituras/{leitura}/edit', [EstacaoController::class, 'editLeitura'])->name('leituras.edit');
        Route::put('/{estacao}/leituras/{leitura}', [EstacaoController::class, 'updateLeitura'])->name('leituras.update');
        Route::post('/{estacao}/leituras/{leitura}/validate', [EstacaoController::class, 'validateLeitura'])->name('leituras.validate');
    });
    
    // Boletins
    Route::prefix('boletins')->name('boletins.')->group(function () {
        Route::get('/', [BoletimController::class, 'index'])->name('index');
        Route::get('/create', [BoletimController::class, 'create'])->name('create');
        Route::post('/', [BoletimController::class, 'store'])->name('store');
        Route::get('/{boletim}', [BoletimController::class, 'show'])->name('show');
        Route::get('/{boletim}/edit', [BoletimController::class, 'edit'])->name('edit');
        Route::put('/{boletim}', [BoletimController::class, 'update'])->name('update');
        Route::delete('/{boletim}', [BoletimController::class, 'destroy'])->name('destroy');
        Route::post('/{boletim}/approve', [BoletimController::class, 'approve'])->name('approve');
        Route::post('/{boletim}/publish', [BoletimController::class, 'publish'])->name('publish');
        Route::get('/{boletim}/pdf', [BoletimController::class, 'downloadPdf'])->name('pdf');
    });
    
    // Alertas
    Route::prefix('alertas')->name('alertas.')->group(function () {
        Route::get('/', [AlertaController::class, 'index'])->name('index');
        Route::get('/{alerta}', [AlertaController::class, 'show'])->name('show');
        Route::post('/{alerta}/resolve', [AlertaController::class, 'resolve'])->name('resolve');
        Route::post('/{alerta}/cancel', [AlertaController::class, 'cancel'])->name('cancel');
    });
    
    // Importação
    Route::prefix('importacao')->name('importacao.')->group(function () {
        Route::get('/', [ImportacaoController::class, 'index'])->name('index');
        Route::post('/barragens', [ImportacaoController::class, 'importBarragens'])->name('barragens');
        Route::post('/estacoes', [ImportacaoController::class, 'importEstacoes'])->name('estacoes');
        Route::post('/leituras', [ImportacaoController::class, 'importLeituras'])->name('leituras');
    });
    
    // API Routes para AJAX
    Route::prefix('api')->name('api.')->group(function () {
        Route::get('/dashboard/stats', [DashboardController::class, 'getStats'])->name('dashboard.stats');
        Route::get('/barragens/{barragem}/historico', [BarragemController::class, 'getHistorico'])->name('barragens.historico');
        Route::get('/estacoes/{estacao}/historico', [EstacaoController::class, 'getHistorico'])->name('estacoes.historico');
        Route::get('/alertas/ativos', [AlertaController::class, 'getAtivos'])->name('alertas.ativos');
    });
});

require __DIR__.'/auth.php';