<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
        'scheme' => 'https',
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'twilio' => [
        'sid' => env('TWILIO_SID'),
        'auth_token' => env('TWILIO_AUTH_TOKEN'),
        'phone_number' => env('TWILIO_PHONE_NUMBER'),
    ],

    'notifications' => [
        'emergency_sms_enabled' => env('EMERGENCY_SMS_ENABLED', true),
        'alert_email_enabled' => env('ALERT_EMAIL_ENABLED', true),
        'escalation_enabled' => env('NOTIFICATION_ESCALATION_ENABLED', true),
        'escalation_time_minutes' => env('NOTIFICATION_ESCALATION_TIME', 30),
        'daily_report_time' => env('DAILY_REPORT_TIME', '08:00'),
    ],

    'seba' => [
        // Primary API connection
        'api_url' => env('SEBA_API_URL'),
        'username' => env('SEBA_USERNAME'),
        'password' => env('SEBA_PASSWORD'),
        'api_key' => env('SEBA_API_KEY'),
        'timeout' => env('SEBA_TIMEOUT', 30),

        // Alternative connection methods
        'sensorthings_url' => env('SEBA_SENSORTHINGS_URL'),
        'csv_download_url' => env('SEBA_CSV_DOWNLOAD_URL'),

        // FTP integration (if needed)
        'ftp_host' => env('SEBA_FTP_HOST'),
        'ftp_username' => env('SEBA_FTP_USERNAME'),
        'ftp_password' => env('SEBA_FTP_PASSWORD'),

        // Integration settings
        'auto_import_enabled' => env('SEBA_AUTO_IMPORT_ENABLED', true),
        'default_interval_minutes' => env('SEBA_DEFAULT_INTERVAL_MINUTES', 60),
        'max_parallel_requests' => env('SEBA_MAX_PARALLEL_REQUESTS', 3),
        'retry_attempts' => env('SEBA_RETRY_ATTEMPTS', 3),
        'retry_delay_seconds' => env('SEBA_RETRY_DELAY_SECONDS', 5),
    ],

];