<?php
// database/migrations/2024_01_01_100003_create_leituras_barragens_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('leituras_barragens', function (Blueprint $table) {
            $table->id();
            $table->foreignId('barragem_id')->constrained('barragens');
            $table->date('data_leitura');
            $table->time('hora_leitura');
            $table->decimal('cota_actual', 10, 2);
            $table->decimal('volume_actual', 15, 2)->nullable();
            $table->decimal('percentagem_enchimento', 5, 2)->nullable();
            $table->decimal('caudal_afluente', 10, 3)->nullable();
            $table->decimal('caudal_efluente', 10, 3)->nullable();
            $table->decimal('descarga_fundo', 10, 3)->nullable();
            $table->decimal('descarga_superficie', 10, 3)->nullable();
            $table->decimal('caudal_ecologico', 10, 3)->nullable();
            $table->decimal('caudal_turbinado', 10, 3)->nullable();
            $table->decimal('caudal_descarregador', 10, 3)->nullable();
            $table->decimal('evaporacao', 10, 3)->nullable();
            $table->decimal('infiltracao', 10, 3)->nullable();
            $table->decimal('variacao_volume', 15, 2)->nullable();
            $table->decimal('comparacao_ano_anterior', 5, 2)->nullable();
            $table->decimal('descarga_total', 10, 3)->nullable();
            $table->foreignId('operador_id')->nullable()->constrained('users');
            $table->enum('metodo_leitura', ['manual', 'automatico', 'telemetria'])->default('manual');
            $table->text('observacoes')->nullable();
            $table->boolean('validado')->default(false);
            $table->foreignId('validado_por')->nullable()->constrained('users');
            $table->timestamp('data_validacao')->nullable();
            $table->timestamps();
            
            $table->index(['barragem_id', 'data_leitura']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('leituras_barragens');
    }
};