<?php
// database/migrations/2024_01_01_100004_create_estacoes_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('estacoes', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('codigo', 50)->unique();
            $table->enum('tipo', ['hidrometrica', 'pluviometrica', 'meteorologica', 'climatologica']);
            $table->foreignId('bacia_hidrografica_id')->nullable()->constrained('bacias_hidrograficas');
            $table->string('provincia', 100)->nullable();
            $table->string('distrito', 100)->nullable();
            $table->string('rio', 100)->nullable();
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->decimal('altitude', 10, 2)->nullable();
            $table->decimal('nivel_alerta', 10, 2)->nullable();
            $table->date('data_instalacao')->nullable();
            $table->string('equipamento')->nullable();
            $table->enum('frequencia_leitura', ['horaria', 'diaria', '6_horas', '12_horas'])->default('diaria');
            $table->enum('estado', ['activa', 'inactiva', 'manutencao'])->default('activa');
            $table->text('observacoes')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('estacoes');
    }
};