<?php
// database/migrations/2024_01_01_100006_create_boletins_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('boletins', function (Blueprint $table) {
            $table->id();
            $table->string('numero_edicao', 50);
            $table->enum('tipo', ['diario', 'semanal', 'mensal', 'emergencia', 'hidrologico_regional', 'informativo_barragens']);
            $table->date('data_emissao');
            $table->time('hora_emissao');
            $table->date('periodo_inicio')->nullable();
            $table->date('periodo_fim')->nullable();
            $table->text('situacao_prevalecente')->nullable();
            $table->text('previsao_hidrologica')->nullable();
            $table->text('alertas_precaucoes')->nullable();
            $table->json('dados_completos')->nullable();
            $table->foreignId('elaborado_por')->nullable()->constrained('users');
            $table->foreignId('aprovado_por')->nullable()->constrained('users');
            $table->enum('estado', ['rascunho', 'revisao', 'aprovado', 'publicado'])->default('rascunho');
            $table->string('arquivo_pdf')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('boletins');
    }
};