<?php
// database/migrations/2024_01_01_100007_create_alertas_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('alertas', function (Blueprint $table) {
            $table->id();
            $table->enum('tipo', ['nivel_critico', 'descarga', 'precipitacao', 'emergencia']);
            $table->enum('nivel', ['informacao', 'atencao', 'alerta', 'emergencia']);
            $table->foreignId('barragem_id')->nullable()->constrained('barragens');
            $table->foreignId('estacao_id')->nullable()->constrained('estacoes');
            $table->string('titulo');
            $table->text('descricao');
            $table->decimal('valor_registado', 15, 3)->nullable();
            $table->decimal('valor_limite', 15, 3)->nullable();
            $table->datetime('data_inicio');
            $table->datetime('data_fim')->nullable();
            $table->enum('estado', ['activo', 'resolvido', 'cancelado'])->default('activo');
            $table->text('acoes_tomadas')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('alertas');
    }
};