<?php
// database/migrations/2024_01_01_100009_create_curvas_descarga_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('curvas_descarga', function (Blueprint $table) {
            $table->id();
            $table->foreignId('estacao_id')->constrained('estacoes');
            $table->decimal('nivel', 10, 2);
            $table->decimal('caudal', 15, 3);
            $table->date('data_calibracao');
            $table->boolean('ativo')->default(true);
            $table->text('observacoes')->nullable();
            $table->timestamps();
            
            $table->unique(['estacao_id', 'nivel']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('curvas_descarga');
    }
};