<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Verificar se campos já existem antes de adicionar
            if (!Schema::hasColumn('users', 'notificacao_sms')) {
                $table->boolean('notificacao_sms')->default(true)->after('telefone');
            }
            if (!Schema::hasColumn('users', 'notificacao_email')) {
                $table->boolean('notificacao_email')->default(true)->after(Schema::hasColumn('users', 'notificacao_sms') ? 'notificacao_sms' : 'telefone');
            }
            if (!Schema::hasColumn('users', 'notificacao_emergencia')) {
                $table->boolean('notificacao_emergencia')->default(true)->after('notificacao_email');
            }
            if (!Schema::hasColumn('users', 'niveis_notificacao')) {
                $table->json('niveis_notificacao')->nullable()->after('notificacao_emergencia');
            }
            if (!Schema::hasColumn('users', 'nivel_escalacao')) {
                $table->enum('nivel_escalacao', ['basico', 'supervisor', 'director'])->default('basico')->after('niveis_notificacao');
            }
            if (!Schema::hasColumn('users', 'receber_relatorio_diario')) {
                $table->boolean('receber_relatorio_diario')->default(false)->after('nivel_escalacao');
            }
            if (!Schema::hasColumn('users', 'horario_relatorio')) {
                $table->time('horario_relatorio')->default('08:00')->after('receber_relatorio_diario');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Remover apenas campos que foram adicionados nesta migração
            $fields = [
                'notificacao_sms',
                'notificacao_email',
                'notificacao_emergencia',
                'niveis_notificacao',
                'nivel_escalacao',
                'receber_relatorio_diario',
                'horario_relatorio'
            ];
            
            foreach ($fields as $field) {
                if (Schema::hasColumn('users', $field)) {
                    $table->dropColumn($field);
                }
            }
        });
    }
};