<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notificacao_enviadas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('alerta_id')->nullable()->constrained('alertas')->onDelete('set null');
            $table->enum('tipo', ['sms', 'email', 'push'])->default('sms');
            $table->enum('categoria', ['alerta', 'emergencia', 'escalacao', 'resolucao', 'relatorio'])->default('alerta');
            $table->string('destinatario'); // telefone ou email
            $table->text('conteudo');
            $table->enum('status', ['pendente', 'enviado', 'entregue', 'falhado'])->default('pendente');
            $table->string('message_id')->nullable(); // ID do Twilio ou serviço de email
            $table->json('resposta_servico')->nullable(); // resposta completa do serviço
            $table->text('erro')->nullable();
            $table->timestamp('enviado_em')->nullable();
            $table->timestamp('entregue_em')->nullable();
            $table->timestamps();
            
            $table->index(['user_id', 'tipo']);
            $table->index(['alerta_id', 'categoria']);
            $table->index(['status', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notificacao_enviadas');
    }
};