<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('notificacao_enviadas', function (Blueprint $table) {
            // Renomear message_id para external_id
            $table->renameColumn('message_id', 'external_id');

            // Renomear erro para erro_detalhes
            $table->renameColumn('erro', 'erro_detalhes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('notificacao_enviadas', function (Blueprint $table) {
            // Reverter as mudanças
            $table->renameColumn('external_id', 'message_id');
            $table->renameColumn('erro_detalhes', 'erro');
        });
    }
};
