<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('estacoes', function (Blueprint $table) {
            $table->string('seba_station_id')->nullable()->after('codigo');
            $table->string('seba_station_name')->nullable()->after('seba_station_id');
            $table->enum('seba_integration_type', ['rest_api', 'sensorthings', 'csv_download', 'ftp'])->nullable()->after('seba_station_name');
            $table->json('seba_config')->nullable()->after('seba_integration_type'); // Configurações específicas
            $table->timestamp('ultima_sincronizacao_seba')->nullable()->after('seba_config');
            $table->boolean('auto_importacao_ativa')->default(false)->after('ultima_sincronizacao_seba');
            $table->integer('intervalo_importacao_minutos')->default(60)->after('auto_importacao_ativa'); // 60 minutos padrão

            $table->index('seba_station_id');
            $table->index('auto_importacao_ativa');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('estacoes', function (Blueprint $table) {
            $table->dropIndex(['seba_station_id']);
            $table->dropIndex(['auto_importacao_ativa']);

            $table->dropColumn([
                'seba_station_id',
                'seba_station_name',
                'seba_integration_type',
                'seba_config',
                'ultima_sincronizacao_seba',
                'auto_importacao_ativa',
                'intervalo_importacao_minutos'
            ]);
        });
    }
};
