<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('estacoes', function (Blueprint $table) {
            // Campo de alerta baseado em cota
            $table->decimal('cota_alerta', 10, 2)->nullable()->after('nivel_alerta');

            // Configuração do sistema de cotas
            $table->boolean('trabalha_com_cotas')->default(false)->after('observacoes');
            $table->enum('tipo_entrada_cotas', ['automatica', 'manual'])->default('automatica')->after('trabalha_com_cotas');

            // Parâmetros para fórmulas de cotas
            $table->decimal('cota_referencia', 12, 3)->nullable()->after('tipo_entrada_cotas');
            $table->enum('formula_cota_tipo', ['simples', 'linear', 'completa', 'personalizada'])->default('simples')->after('cota_referencia');
            $table->decimal('formula_cota_a', 15, 6)->default(1.0)->after('formula_cota_tipo');
            $table->decimal('formula_cota_b', 15, 6)->default(0.0)->after('formula_cota_a');
            $table->decimal('formula_cota_c', 12, 3)->default(0.0)->after('formula_cota_b');
            $table->text('formula_personalizada')->nullable()->after('formula_cota_c');

            // Campos para integração SEBA (se não existir)
            if (!Schema::hasColumn('estacoes', 'seba_station_id')) {
                $table->string('seba_station_id')->nullable()->after('formula_personalizada');
            }
            if (!Schema::hasColumn('estacoes', 'ativa')) {
                $table->boolean('ativa')->default(true)->after('seba_station_id');
            }
        });
    }

    public function down()
    {
        Schema::table('estacoes', function (Blueprint $table) {
            $table->dropColumn([
                'cota_alerta',
                'trabalha_com_cotas',
                'tipo_entrada_cotas',
                'cota_referencia',
                'formula_cota_tipo',
                'formula_cota_a',
                'formula_cota_b',
                'formula_cota_c',
                'formula_personalizada'
            ]);

            // Só remover estes campos se foram criados por esta migration
            if (Schema::hasColumn('estacoes', 'seba_station_id')) {
                // Verificar se não existe migration anterior que criou este campo
                try {
                    $table->dropColumn('seba_station_id');
                } catch (Exception $e) {
                    // Campo pode ter sido criado por outra migration
                }
            }

            if (Schema::hasColumn('estacoes', 'ativa')) {
                try {
                    $table->dropColumn('ativa');
                } catch (Exception $e) {
                    // Campo pode ter sido criado por outra migration
                }
            }
        });
    }
};