<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('leituras_estacoes', function (Blueprint $table) {
            // Campos de cotas por horário
            $table->decimal('cota_6h', 12, 3)->nullable()->after('nivel_18h');
            $table->decimal('cota_12h', 12, 3)->nullable()->after('cota_6h');
            $table->decimal('cota_18h', 12, 3)->nullable()->after('cota_12h');
            $table->decimal('cota_hidrometrica', 12, 3)->nullable()->after('nivel_hidrometrico');

            // Campos para compatibilidade com SEBA
            $table->time('hora_leitura')->nullable()->after('data_leitura');
            $table->decimal('precipitacao', 10, 2)->nullable()->after('precipitacao_mm');
            $table->decimal('temperatura', 5, 2)->nullable()->after('temperatura_min');

            // Campos de controle
            $table->string('origem')->nullable()->after('observacoes');
            $table->boolean('importado_automaticamente')->default(false)->after('origem');

            // Índices para performance
            $table->index(['estacao_id', 'cota_hidrometrica']);
            $table->index(['data_leitura', 'importado_automaticamente']);
        });
    }

    public function down()
    {
        Schema::table('leituras_estacoes', function (Blueprint $table) {
            // Remover índices primeiro
            $table->dropIndex(['estacao_id', 'cota_hidrometrica']);
            $table->dropIndex(['data_leitura', 'importado_automaticamente']);

            // Remover colunas
            $table->dropColumn([
                'cota_6h',
                'cota_12h',
                'cota_18h',
                'cota_hidrometrica',
                'hora_leitura',
                'precipitacao',
                'temperatura',
                'origem',
                'importado_automaticamente'
            ]);
        });
    }
};