<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('barragens', function (Blueprint $table) {
            // Remover campos antigos de alerta (se existirem e não foram usados)
            if (Schema::hasColumn('barragens', 'nivel_alerta')) {
                // Migrar dados se necessário antes de remover
                DB::statement('UPDATE barragens SET cota_npa = nivel_alerta WHERE nivel_alerta IS NOT NULL AND cota_npa IS NULL');
                $table->dropColumn('nivel_alerta');
            }

            if (Schema::hasColumn('barragens', 'nivel_emergencia')) {
                // Migrar dados se necessário antes de remover
                DB::statement('UPDATE barragens SET cota_nmc = nivel_emergencia WHERE nivel_emergencia IS NOT NULL AND cota_nmc IS NULL');
                $table->dropColumn('nivel_emergencia');
            }

            // Garantir que os campos corretos existem com comentários explicativos
            if (!Schema::hasColumn('barragens', 'cota_npa')) {
                $table->decimal('cota_npa', 10, 3)->nullable()->comment('Nível de Pleno Armazenamento (m)');
            }

            if (!Schema::hasColumn('barragens', 'cota_nme')) {
                $table->decimal('cota_nme', 10, 3)->nullable()->comment('Nível Mínimo de Exploração (m)');
            }

            if (!Schema::hasColumn('barragens', 'cota_nmc')) {
                $table->decimal('cota_nmc', 10, 3)->nullable()->comment('Nível Máximo de Cheia (m)');
            }

            // Adicionar índices para performance
            $table->index(['cota_npa', 'cota_nme', 'cota_nmc'], 'idx_barragem_niveis_seguranca');
        });
    }

    public function down()
    {
        Schema::table('barragens', function (Blueprint $table) {
            // Restaurar campos antigos se necessário
            if (!Schema::hasColumn('barragens', 'nivel_alerta')) {
                $table->decimal('nivel_alerta', 10, 2)->nullable();
            }

            if (!Schema::hasColumn('barragens', 'nivel_emergencia')) {
                $table->decimal('nivel_emergencia', 10, 2)->nullable();
            }

            // Remover índice
            $table->dropIndex('idx_barragem_niveis_seguranca');
        });
    }
};