<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('barragens', function (Blueprint $table) {
            // Atualizar comentários dos campos de volume para refletir nova unidade
            $table->decimal('volume_maximo', 12, 3)->nullable()->change()->comment('Volume máximo (Mm³)');
            $table->decimal('volume_morto', 12, 3)->nullable()->change()->comment('Volume morto (Mm³)');
            $table->decimal('volume_util', 12, 3)->nullable()->change()->comment('Volume útil (Mm³)');
            $table->decimal('capacidade_total', 12, 3)->nullable()->change()->comment('Capacidade total (Mm³)');
        });

        // Atualizar também tabela de leituras se existir campos de volume
        if (Schema::hasTable('leituras_barragens')) {
            Schema::table('leituras_barragens', function (Blueprint $table) {
                if (Schema::hasColumn('leituras_barragens', 'volume_actual')) {
                    $table->decimal('volume_actual', 12, 3)->nullable()->change()->comment('Volume atual (Mm³)');
                }

                if (Schema::hasColumn('leituras_barragens', 'variacao_volume')) {
                    $table->decimal('variacao_volume', 12, 3)->nullable()->change()->comment('Variação de volume (Mm³)');
                }
            });
        }

        // Atualizar tabela de curvas cota-volume se existir
        if (Schema::hasTable('curvas_cota_volume')) {
            Schema::table('curvas_cota_volume', function (Blueprint $table) {
                if (Schema::hasColumn('curvas_cota_volume', 'volume')) {
                    $table->decimal('volume', 12, 3)->nullable()->change()->comment('Volume correspondente (Mm³)');
                }
            });
        }
    }

    public function down()
    {
        Schema::table('barragens', function (Blueprint $table) {
            // Reverter comentários se necessário
            $table->decimal('volume_maximo', 10, 2)->nullable()->change()->comment('Volume máximo (hm³)');
            $table->decimal('volume_morto', 10, 2)->nullable()->change()->comment('Volume morto (hm³)');
            $table->decimal('volume_util', 10, 2)->nullable()->change()->comment('Volume útil (hm³)');
            $table->decimal('capacidade_total', 10, 2)->nullable()->change()->comment('Capacidade total (hm³)');
        });

        if (Schema::hasTable('leituras_barragens')) {
            Schema::table('leituras_barragens', function (Blueprint $table) {
                if (Schema::hasColumn('leituras_barragens', 'volume_actual')) {
                    $table->decimal('volume_actual', 10, 2)->nullable()->change()->comment('Volume atual (hm³)');
                }

                if (Schema::hasColumn('leituras_barragens', 'variacao_volume')) {
                    $table->decimal('variacao_volume', 10, 2)->nullable()->change()->comment('Variação de volume (hm³)');
                }
            });
        }

        if (Schema::hasTable('curvas_cota_volume')) {
            Schema::table('curvas_cota_volume', function (Blueprint $table) {
                if (Schema::hasColumn('curvas_cota_volume', 'volume')) {
                    $table->decimal('volume', 10, 2)->nullable()->change()->comment('Volume correspondente (hm³)');
                }
            });
        }
    }
};