<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        // Alterar o enum do tipo de estação para incluir 'evaporimetrica'
        DB::statement("ALTER TABLE estacoes MODIFY COLUMN tipo ENUM('hidrometrica', 'pluviometrica', 'meteorologica', 'climatologica', 'evaporimetrica') NOT NULL");
    }

    public function down()
    {
        // Primeiro, migrar dados de 'evaporimetrica' para 'meteorologica' se existir
        DB::statement("UPDATE estacoes SET tipo = 'meteorologica' WHERE tipo = 'evaporimetrica'");

        // Depois, reverter o enum
        DB::statement("ALTER TABLE estacoes MODIFY COLUMN tipo ENUM('hidrometrica', 'pluviometrica', 'meteorologica', 'climatologica') NOT NULL");
    }
};