<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('curvas_volume', function (Blueprint $table) {
            $table->id();
            $table->foreignId('barragem_id')->constrained('barragens')->onDelete('cascade');
            $table->decimal('cota', 8, 3); // Cota em metros
            $table->decimal('volume', 10, 3); // Volume em Mm³
            $table->decimal('area', 10, 3)->nullable(); // Área em km²
            $table->text('observacoes')->nullable();
            $table->foreignId('criado_por')->constrained('users');
            $table->timestamps();

            // Índices para performance
            $table->index(['barragem_id', 'cota']);
            $table->unique(['barragem_id', 'cota']); // Uma cota por barragem
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('curvas_volume');
    }
};