<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leituras_estacoes', function (Blueprint $table) {
            // Adicionar novos horários de leitura
            $table->time('hora_9h')->nullable()->after('hora_6h');
            $table->decimal('nivel_9h', 8, 3)->nullable()->after('nivel_6h');
            $table->decimal('cota_9h', 10, 3)->nullable()->after('cota_6h');

            $table->time('hora_15h')->nullable()->after('hora_12h');
            $table->decimal('nivel_15h', 8, 3)->nullable()->after('nivel_12h');
            $table->decimal('cota_15h', 10, 3)->nullable()->after('cota_12h');

            // Campo para marcar dados como "Sem Dados" (F)
            $table->json('campos_sem_dados')->nullable()->comment('Array com campos marcados como F (sem dados)');

            // Campos adicionais para diferentes tipos de estação
            $table->decimal('caudal_manual', 10, 3)->nullable()->comment('Caudal medido manualmente');
            $table->boolean('caudal_estimado')->default(true)->comment('Se o caudal foi estimado por fórmula');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leituras_estacoes', function (Blueprint $table) {
            $table->dropColumn([
                'hora_9h', 'nivel_9h', 'cota_9h',
                'hora_15h', 'nivel_15h', 'cota_15h',
                'campos_sem_dados', 'caudal_manual', 'caudal_estimado'
            ]);
        });
    }
};