<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leituras_barragens', function (Blueprint $table) {
            $table->decimal('precipitacao', 5, 2)->nullable()->after('descarga_total')->comment('Precipitação em mm');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leituras_barragens', function (Blueprint $table) {
            $table->dropColumn('precipitacao');
        });
    }
};
