<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leituras_barragens', function (Blueprint $table) {
            // Campos faltantes identificados na análise do Excel
            $table->decimal('volume_morto', 10, 3)->nullable()->comment('Volume Morto (Mm³) - Volume não utilizável');
            $table->decimal('percentagem_total', 5, 2)->nullable()->comment('% Total da barragem (incluindo volume morto)');
            $table->decimal('caudal_captacao', 10, 3)->nullable()->comment('Captação FIPAG/ETA (m³/s)');
            $table->decimal('volume_armazenado', 10, 3)->nullable()->comment('Volume Total Armazenado (Mm³)');

            // Campos adicionais para compatibilidade total
            $table->decimal('cota_npa', 8, 2)->nullable()->comment('Cota NPA (Nível Pleno Armazenamento)');
            $table->decimal('nivel_minimo', 8, 2)->nullable()->comment('Nível Mínimo Operacional');
            $table->decimal('nivel_maximo', 8, 2)->nullable()->comment('Nível Máximo Operacional');

            // Campos para análise histórica (como no Excel)
            $table->date('data_nivel_minimo')->nullable()->comment('Data que atingiu nível mínimo');
            $table->date('data_nivel_maximo')->nullable()->comment('Data que atingiu nível máximo');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leituras_barragens', function (Blueprint $table) {
            $table->dropColumn([
                'volume_morto',
                'percentagem_total',
                'caudal_captacao',
                'volume_armazenado',
                'cota_npa',
                'nivel_minimo',
                'nivel_maximo',
                'data_nivel_minimo',
                'data_nivel_maximo'
            ]);
        });
    }
};
