<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('divisoes_administrativas', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('codigo')->unique();
            $table->enum('tipo', ['provincia', 'distrito', 'municipio', 'setor', 'zona']);
            $table->foreignId('parent_id')->nullable()->constrained('divisoes_administrativas')->onDelete('cascade');
            $table->decimal('area_km2', 12, 2)->nullable();
            $table->integer('populacao')->nullable();
            $table->text('descricao')->nullable();
            $table->json('limites_geograficos')->nullable(); // GeoJSON
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->boolean('ativo')->default(true);
            $table->timestamps();

            $table->index(['tipo', 'ativo']);
            $table->index('parent_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('divisoes_administrativas');
    }
};
