<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('areas_jurisdicao', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('codigo')->unique();
            $table->text('descricao')->nullable();
            $table->json('limites_geograficos'); // GeoJSON com polígono
            $table->decimal('area_total_km2', 12, 2);
            $table->json('coordenadas_centro')->nullable();
            $table->string('responsavel')->nullable();
            $table->string('contato')->nullable();
            $table->string('email')->nullable();
            $table->boolean('ativo')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('areas_jurisdicao');
    }
};
