<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('bacias_hidrograficas', function (Blueprint $table) {
            $table->foreignId('divisao_administrativa_id')->nullable()->after('id')->constrained('divisoes_administrativas')->onDelete('set null');
            $table->foreignId('area_jurisdicao_id')->nullable()->after('divisao_administrativa_id')->constrained('areas_jurisdicao')->onDelete('set null');
            $table->json('coordenadas_geograficas')->nullable()->after('area_km2');
        });

        Schema::table('estacoes', function (Blueprint $table) {
            $table->foreignId('divisao_administrativa_id')->nullable()->after('bacia_hidrografica_id')->constrained('divisoes_administrativas')->onDelete('set null');
        });

        Schema::table('barragens', function (Blueprint $table) {
            $table->foreignId('divisao_administrativa_id')->nullable()->after('bacia_hidrografica_id')->constrained('divisoes_administrativas')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('bacias_hidrograficas', function (Blueprint $table) {
            $table->dropForeign(['divisao_administrativa_id']);
            $table->dropForeign(['area_jurisdicao_id']);
            $table->dropColumn(['divisao_administrativa_id', 'area_jurisdicao_id', 'coordenadas_geograficas']);
        });

        Schema::table('estacoes', function (Blueprint $table) {
            $table->dropForeign(['divisao_administrativa_id']);
            $table->dropColumn('divisao_administrativa_id');
        });

        Schema::table('barragens', function (Blueprint $table) {
            $table->dropForeign(['divisao_administrativa_id']);
            $table->dropColumn('divisao_administrativa_id');
        });
    }
};
