<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * Tabela para definir permissoes customizadas por divisao/role
     * Permite que operadores em Pemba tenham permissoes diferentes de Nampula
     */
    public function up(): void
    {
        Schema::create('divisao_role_permissions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('divisao_administrativa_id')
                  ->constrained('divisoes_administrativas')
                  ->onDelete('cascade');
            $table->foreignId('role_id')
                  ->constrained('roles')
                  ->onDelete('cascade');
            $table->foreignId('permission_id')
                  ->constrained('permissions')
                  ->onDelete('cascade');

            // Tipo de override:
            // 'grant' = adiciona permissao que o role nao tem globalmente
            // 'revoke' = remove permissao que o role tem globalmente
            $table->enum('tipo', ['grant', 'revoke'])->default('grant');

            $table->timestamps();

            // Combinacao unica
            $table->unique(
                ['divisao_administrativa_id', 'role_id', 'permission_id'],
                'divisao_role_permission_unique'
            );

            // Indices para performance
            $table->index(['divisao_administrativa_id', 'role_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('divisao_role_permissions');
    }
};
