<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $settings = [
            [
                'key' => 'director_name',
                'value' => 'Carlitos Omar',
                'type' => 'text',
                'category' => 'bulletin',
                'label' => 'Nome do Director (Visto)',
                'description' => 'Nome do director que assina "Visto" nos boletins',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'director_title',
                'value' => 'Director Geral',
                'type' => 'text',
                'category' => 'bulletin',
                'label' => 'Cargo do Director (Visto)',
                'description' => 'Cargo do director que assina "Visto" nos boletins',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'chefe_departamento_name',
                'value' => 'João Alberto Miguel Sitoe',
                'type' => 'text',
                'category' => 'bulletin',
                'label' => 'Nome do Chefe de Departamento',
                'description' => 'Nome do chefe do departamento de recursos hídricos (boletim regional)',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'chefe_departamento_title',
                'value' => 'Inspector Superior',
                'type' => 'text',
                'category' => 'bulletin',
                'label' => 'Cargo do Chefe de Departamento',
                'description' => 'Cargo do chefe do departamento (boletim regional)',
                'created_at' => now(),
                'updated_at' => now()
            ],
        ];

        foreach ($settings as $setting) {
            DB::table('system_settings')->updateOrInsert(
                ['key' => $setting['key']],
                $setting
            );
        }
    }

    public function down(): void
    {
        DB::table('system_settings')->whereIn('key', [
            'director_name',
            'director_title',
            'chefe_departamento_name',
            'chefe_departamento_title',
        ])->delete();
    }
};
