<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Alerta;
use App\Models\NotificacaoEnviada;
use Illuminate\Database\Seeder;
use Carbon\Carbon;

class NotificacaoTestSeeder extends Seeder
{
    public function run()
    {
        $user = User::first();
        if (!$user) {
            echo "Nenhum usuário encontrado. Execute o UserSeeder primeiro.\n";
            return;
        }

        $alerta = Alerta::first();
        if (!$alerta) {
            echo "Nenhum alerta encontrado. Criando um alerta de teste...\n";
            $alerta = Alerta::create([
                'tipo' => 'nivel_critico',
                'nivel' => 'alerta',
                'titulo' => 'Teste de Alerta para Notificações',
                'descricao' => 'Este é um alerta criado para testar o sistema de notificações.',
                'valor_registado' => 5.50,
                'valor_limite' => 5.00,
                'data_inicio' => now(),
                'estado' => 'activo',
            ]);
        }

        // Criar diferentes tipos de notificações para teste
        $notificacoes = [
            [
                'user_id' => $user->id,
                'alerta_id' => $alerta->id,
                'tipo' => 'sms',
                'categoria' => 'alerta',
                'destinatario' => '+258843214567',
                'conteudo' => '🔔 ALERTA DO SISTEMA

Nível: Alerta
Tipo: Nível Crítico
Local: Barragem de Teste
Descrição: Teste de alerta para o sistema de notificações
Valor: 5.5
Limite: 5.0
Hora: ' . now()->format('d/m/Y H:i') . '

Sistema Hidrológico - Moçambique',
                'status' => 'enviado',
                'external_id' => 'SMS' . time() . '001',
                'enviado_em' => now()->subMinutes(10),
                'created_at' => now()->subMinutes(10),
            ],
            [
                'user_id' => $user->id,
                'alerta_id' => $alerta->id,
                'tipo' => 'email',
                'categoria' => 'alerta',
                'destinatario' => $user->email,
                'conteudo' => 'Email de alerta enviado para ' . $user->email,
                'status' => 'entregue',
                'external_id' => 'EMAIL' . time() . '001',
                'enviado_em' => now()->subMinutes(8),
                'entregue_em' => now()->subMinutes(7),
                'created_at' => now()->subMinutes(8),
            ],
            [
                'user_id' => $user->id,
                'alerta_id' => $alerta->id,
                'tipo' => 'sms',
                'categoria' => 'emergencia',
                'destinatario' => '+258843214567',
                'conteudo' => '🚨 ALERTA DE EMERGÊNCIA 🚨

Tipo: Nível Crítico
Local: Barragem de Teste
Detalhes: Emergência no sistema hidrológico
Hora: ' . now()->subMinutes(5)->format('d/m/Y H:i') . '

⚠️ AÇÃO IMEDIATA REQUERIDA ⚠️
Sistema Hidrológico - Moçambique',
                'status' => 'falhado',
                'erro_detalhes' => 'Erro ao conectar com o serviço Twilio: Authentication failed',
                'created_at' => now()->subMinutes(5),
            ],
            [
                'user_id' => $user->id,
                'alerta_id' => $alerta->id,
                'tipo' => 'sms',
                'categoria' => 'resolucao',
                'destinatario' => '+258843214567',
                'conteudo' => '✅ ALERTA RESOLVIDO

Alerta: Teste de Alerta para Notificações
Local: Barragem de Teste
Resolvido em: ' . now()->subMinutes(2)->format('d/m/Y H:i') . '
Duração: 3 minutos

Sistema Hidrológico - Moçambique',
                'status' => 'enviado',
                'external_id' => 'SMS' . time() . '002',
                'enviado_em' => now()->subMinutes(2),
                'created_at' => now()->subMinutes(2),
            ],
            [
                'user_id' => $user->id,
                'alerta_id' => null,
                'tipo' => 'sms',
                'categoria' => 'relatorio',
                'destinatario' => '+258843214567',
                'conteudo' => '📊 RELATÓRIO DIÁRIO DE ALERTAS
' . now()->format('d/m/Y') . '

Alertas hoje: 3
Ativos: 1
Resolvidos: 2
Emergências: 0

✅ Todos os alertas críticos resolvidos

Sistema Hidrológico - Moçambique',
                'status' => 'pendente',
                'created_at' => now()->subMinute(),
            ],
        ];

        foreach ($notificacoes as $notificacao) {
            NotificacaoEnviada::create($notificacao);
        }

        echo "Criadas " . count($notificacoes) . " notificações de teste para o usuário {$user->name}\n";
    }
}