<?php
// Temporary script to fix autoloader issues

// Remove any problematic cache files
$dirs_to_clean = [
    __DIR__ . '/bootstrap/cache',
    __DIR__ . '/storage/framework/cache',
    __DIR__ . '/storage/framework/views',
];

foreach ($dirs_to_clean as $dir) {
    if (is_dir($dir)) {
        $files = glob($dir . '/*');
        foreach ($files as $file) {
            if (is_file($file)) {
                @unlink($file);
            }
        }
    }
}

// Regenerate key Laravel files
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    require __DIR__ . '/vendor/autoload.php';

    // Clear compiled config
    $config_cache = __DIR__ . '/bootstrap/cache/config.php';
    if (file_exists($config_cache)) {
        unlink($config_cache);
    }

    // Clear route cache
    $route_cache = __DIR__ . '/bootstrap/cache/routes-v7.php';
    if (file_exists($route_cache)) {
        unlink($route_cache);
    }

    echo "Cache files cleared successfully.\n";
} else {
    echo "Autoloader not found. Please run 'composer install'.\n";
}