# RELATÓRIO DE ANÁLISE DOS FICHEIROS EXCEL DAS BARRAGENS

## RESUMO EXECUTIVO

Análise detalhada dos ficheiros Excel das barragens revelou a estrutura de dados, fórmulas de cálculo e métodos utilizados para determinar as percentagens de enchimento das barragens.

## FICHEIROS ANALISADOS

### 1. Ficheiro Principal: "Cópia de BARRAGENS ACT 8.8.xlsm"
- **20 folhas de cálculo** com dados das barragens
- **Barragens principais**: NAMPULA, NACALA, MUGICA, CHIPEMBE, LOCUMUE, MITUCUE
- **Folhas adicionais**: GRAFICOS DE BARRAGEM, Proj. NPL, Previsão
- **Folhas backup**: NAMPULA B., NACALA.B, MUGICA.B, CHIPEMBE.B, LOCUMUE.B, MITUCUE.B

### 2. Outros Ficheiros
- **SAC-2024-25.xls**: Sistema de Armazenamento de Água (35 folhas)
- **P-332.xls**: Dados de precipitação (18 folhas)
- **E-127-2011-12.xls**: Dados hidrológicos mensais (13 folhas)

## ESTRUTURA DOS DADOS DAS BARRAGENS

### Campos Principais Identificados:
1. **Data/Hora**: Registos diários com timestamps
2. **NPA**: Nível Pleno de Armazenamento
3. **NME**: Nível Mínimo de Exploração
4. **V.MORTO**: Volume Morto
5. **Nivel**: Nível de água atual
6. **Precipitação**: Dados de chuva
7. **Cota**: Cota do nível de água
8. **DESCARGAS**: Caudais descarregados
9. **V.TOTAL**: Volume Total
10. **V.UTIL**: Volume Útil
11. **% TOTAL**: Percentagem do volume total
12. **% UTIL**: Percentagem do volume útil

### Constantes Importantes por Barragem:

#### BARRAGEM NAMPULA:
- **Capacidade Total**: 3.9 Mm³
- **Capacidade Útil**: 3.25 Mm³
- **Volume Morto**: 0.353 Mm³
- **NPA**: 336 (metros)
- **NME**: 327 (metros)

#### BARRAGEM NACALA:
- **Capacidade Total**: 6.6 Mm³
- **Capacidade Útil**: Diferença entre total e volume morto
- **NPA**: 78.5 (metros)
- **Diferencial cota**: 14.31 (metros)

## FÓRMULAS DE CÁLCULO IDENTIFICADAS

### 1. FÓRMULA PRINCIPAL DE PERCENTAGEM TOTAL:
```excel
=(VOLUME_TOTAL / CAPACIDADE_TOTAL) * 100
```
**Exemplo para Nampula**: `=(M4/3.9)*100`

### 2. FÓRMULA PRINCIPAL DE PERCENTAGEM ÚTIL:
```excel
=(VOLUME_UTIL / CAPACIDADE_UTIL) * 100
```
**Exemplo para Nampula**: `=(W4/3.25)*100`

### 3. FÓRMULA DE CÁLCULO DE COTA:
```excel
=NPA-(DIFERENCIAL-NIVEL_ATUAL)
```
**Exemplo para Nampula**: `=336-(9.86-F4)`
**Exemplo para Nacala**: `=78.5-(14.31-J3)`

### 4. FÓRMULA DE VOLUME ÚTIL:
```excel
=VOLUME_TOTAL - VOLUME_MORTO
```
**Exemplo**: `=M4-E4`

### 5. FÓRMULA DE CÁLCULO DE DESCARGAS:
```excel
=((COTA-NPA_BASE)^(3/2))*COEFICIENTE*FATOR
```
**Exemplo para Nampula**: `=((AH4-336)^(3/2))*1.838*133`

### 6. CONVERSÃO PARA m³/DIA:
```excel
=DESCARGA_m3_s * 24 * 3600
```
**Exemplo**: `=AN4*24*3600`

## PADRÕES DE FÓRMULAS IDENTIFICADOS

### Padrão 1: Percentagem Simples
- **Padrão**: `=(CELL/CONSTANTE)*100`
- **Ocorrências**: Mais de 1000 fórmulas
- **Uso**: Cálculo direto de percentagem de enchimento

### Padrão 2: Cálculo de Cota
- **Padrão**: `=CONSTANTE-(DIFERENCIAL-CELL)`
- **Uso**: Determinar a cota atual baseada no nível

### Padrão 3: Conversões de Unidades
- **Padrão**: `=CELL*FATOR_CONVERSAO`
- **Uso**: Converter entre diferentes unidades (m³/s para m³/dia)

## CONSTANTES CRÍTICAS POR BARRAGEM

### NAMPULA:
- Volume Total Máximo: **3.9 Mm³**
- Volume Útil Máximo: **3.25 Mm³**
- NPA: **336 metros**
- Diferencial de cota: **9.86**
- Coeficiente de descarga: **1.838**
- Fator multiplicador: **133**

### NACALA:
- Volume Total Máximo: **6.6 Mm³**
- NPA: **78.5 metros**
- Diferencial de cota: **14.31**

## ESTRUTURA DOS ANOS HIDROLÓGICOS

Os dados estão organizados por anos hidrológicos:
- **2012-13** a **2024-25**
- Cada ano tem colunas separadas para:
  - Níveis de água
  - Precipitação
  - Volumes (Total e Útil)
  - Percentagens de enchimento
  - Descargas

## IMPLEMENTAÇÃO RECOMENDADA

### 1. Algoritmo de Cálculo Base:
```python
def calcular_percentagem_enchimento(volume_atual, volume_total_maximo):
    return (volume_atual / volume_total_maximo) * 100

def calcular_percentagem_util(volume_atual, volume_morto, volume_util_maximo):
    volume_util_atual = volume_atual - volume_morto
    return (volume_util_atual / volume_util_maximo) * 100
```

### 2. Parâmetros por Barragem:
```python
BARRAGENS = {
    'NAMPULA': {
        'volume_total_max': 3.9,      # Mm³
        'volume_util_max': 3.25,      # Mm³
        'volume_morto': 0.353,        # Mm³
        'npa': 336,                   # metros
        'diferencial_cota': 9.86      # metros
    },
    'NACALA': {
        'volume_total_max': 6.6,      # Mm³
        'npa': 78.5,                  # metros
        'diferencial_cota': 14.31     # metros
    },
    # ... outras barragens
}
```

### 3. Fórmula de Cota:
```python
def calcular_cota(npa, diferencial, nivel_atual):
    return npa - (diferencial - nivel_atual)
```

### 4. Cálculo de Descargas:
```python
def calcular_descarga(cota, npa_base, coeficiente, fator):
    if cota > npa_base:
        return ((cota - npa_base) ** 1.5) * coeficiente * fator
    return 0
```

## VALIDAÇÃO DOS CÁLCULOS

### Exemplos de Validação (Barragem NAMPULA):

1. **Volume total de 2.901 Mm³**:
   - Percentagem = (2.901 / 3.9) × 100 = 74.38%
   - Confirmado nas fórmulas: `=(AL5/3.9)*100`

2. **Volume útil calculado**:
   - Volume útil = 2.901 - 0.353 = 2.548 Mm³
   - Percentagem útil = (2.548 / 3.25) × 100 = 78.4%

## GRÁFICOS E VISUALIZAÇÕES

O ficheiro contém uma folha "GRAFICOS DE BARRAGEM" que provavelmente contém:
- Gráficos de evolução temporal dos níveis
- Comparações entre barragens
- Visualizações de percentagens de enchimento

## RECOMENDAÇÕES PARA IMPLEMENTAÇÃO

1. **Manter as fórmulas exatas** encontradas no Excel
2. **Usar as constantes específicas** de cada barragem
3. **Validar os cálculos** com os dados existentes
4. **Implementar verificações** para valores fora do intervalo esperado
5. **Manter a estrutura de anos hidrológicos** para comparações históricas

## CONCLUSÃO

A análise revelou um sistema bem estruturado com fórmulas consistentes para calcular as percentagens de enchimento das barragens. As fórmulas principais são baseadas em divisões simples dos volumes atuais pelas capacidades máximas, multiplicadas por 100 para obter percentagens.

O sistema está preparado para múltiplos anos hidrológicos e permite comparações históricas detalhadas. A implementação deve seguir exatamente as fórmulas e constantes identificadas para manter a compatibilidade com o sistema existente.