@extends('layouts.app')

@section('title', 'Permissoes - ' . $divisao->nome)

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex justify-between items-start mb-6">
            <div>
                <div class="flex items-center gap-3">
                    <div class="h-12 w-12 rounded-lg flex items-center justify-center text-white font-bold
                        {{ $divisao->tipo == 'provincia' ? 'bg-purple-500' : ($divisao->tipo == 'distrito' ? 'bg-blue-500' : 'bg-green-500') }}">
                        <i class="fas {{ $divisao->tipo == 'provincia' ? 'fa-map' : 'fa-map-marker-alt' }} text-xl"></i>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900">Permissoes Customizadas</h1>
                        <p class="text-sm text-gray-600">{{ $divisao->nome }} ({{ ucfirst($divisao->tipo) }})</p>
                    </div>
                </div>
            </div>
            <a href="{{ route('admin.divisoes.permissions.index') }}" class="bg-gray-600 hover:bg-gray-700 text-white py-2 px-4 rounded-lg">
                <i class="fas fa-arrow-left mr-1"></i> Voltar
            </a>
        </div>

        @if(session('success'))
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
            {{ session('success') }}
        </div>
        @endif

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Formulario para adicionar override -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-lg shadow p-6 sticky top-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Adicionar Override</h3>

                    <form action="{{ route('admin.divisoes.permissions.store', $divisao) }}" method="POST" class="space-y-4">
                        @csrf

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Role *</label>
                            <select name="role_id" required class="w-full border-gray-300 rounded-md shadow-sm">
                                <option value="">Seleccione...</option>
                                @foreach($roles as $role)
                                @if($role->name !== 'Administrador')
                                <option value="{{ $role->id }}">{{ $role->name }}</option>
                                @endif
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Permissao *</label>
                            <select name="permission_id" required class="w-full border-gray-300 rounded-md shadow-sm">
                                <option value="">Seleccione...</option>
                                @foreach($permissions as $permission)
                                <option value="{{ $permission->id }}">{{ $permission->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Tipo *</label>
                            <div class="space-y-2">
                                <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                                    <input type="radio" name="tipo" value="grant" checked class="text-green-600">
                                    <div class="ml-3">
                                        <span class="text-sm font-medium text-gray-900">Conceder (Grant)</span>
                                        <p class="text-xs text-gray-500">Adiciona esta permissao ao role nesta divisao</p>
                                    </div>
                                </label>
                                <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                                    <input type="radio" name="tipo" value="revoke" class="text-red-600">
                                    <div class="ml-3">
                                        <span class="text-sm font-medium text-gray-900">Revogar (Revoke)</span>
                                        <p class="text-xs text-gray-500">Remove esta permissao do role nesta divisao</p>
                                    </div>
                                </label>
                            </div>
                        </div>

                        <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded-md">
                            <i class="fas fa-plus mr-1"></i> Adicionar Override
                        </button>
                    </form>

                    <!-- Info -->
                    <div class="mt-4 p-3 bg-yellow-50 border border-yellow-200 rounded-lg text-xs text-yellow-800">
                        <i class="fas fa-lightbulb mr-1"></i>
                        <strong>Nota:</strong> Overrides sao aplicados apenas aos utilizadores atribuidos a esta divisao.
                    </div>
                </div>
            </div>

            <!-- Lista de overrides actuais -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-lg shadow">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg font-medium text-gray-900">Overrides Actuais</h3>
                    </div>

                    @if($overrides->isEmpty())
                    <div class="px-6 py-12 text-center text-gray-500">
                        <i class="fas fa-shield-alt text-4xl mb-4"></i>
                        <p>Nenhum override configurado para esta divisao</p>
                        <p class="text-sm mt-1">Use o formulario ao lado para adicionar permissoes customizadas</p>
                    </div>
                    @else
                    <div class="divide-y divide-gray-200">
                        @foreach($overrides as $roleId => $roleOverrides)
                        @php $role = $roleOverrides->first()->role; @endphp
                        <div class="p-6">
                            <div class="flex items-center justify-between mb-4">
                                <h4 class="font-medium text-gray-900 flex items-center">
                                    <i class="fas fa-user-tag mr-2 text-blue-500"></i>
                                    {{ $role->name }}
                                </h4>
                                <span class="text-sm text-gray-500">{{ $roleOverrides->count() }} override(s)</span>
                            </div>

                            <div class="space-y-2">
                                @foreach($roleOverrides as $override)
                                <div class="flex items-center justify-between p-3 rounded-lg
                                    {{ $override->tipo == 'grant' ? 'bg-green-50 border border-green-200' : 'bg-red-50 border border-red-200' }}">
                                    <div class="flex items-center">
                                        <span class="inline-flex items-center justify-center w-8 h-8 rounded-full mr-3
                                            {{ $override->tipo == 'grant' ? 'bg-green-500 text-white' : 'bg-red-500 text-white' }}">
                                            <i class="fas {{ $override->tipo == 'grant' ? 'fa-plus' : 'fa-minus' }} text-xs"></i>
                                        </span>
                                        <div>
                                            <span class="text-sm font-medium text-gray-900">{{ $override->permission->name }}</span>
                                            <span class="ml-2 text-xs {{ $override->tipo == 'grant' ? 'text-green-600' : 'text-red-600' }}">
                                                ({{ $override->tipo == 'grant' ? 'Concedido' : 'Revogado' }})
                                            </span>
                                        </div>
                                    </div>
                                    <form action="{{ route('admin.divisoes.permissions.destroy', [$divisao, $override]) }}" method="POST"
                                          onsubmit="return confirm('Remover este override?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-gray-400 hover:text-red-500" title="Remover">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @endif
                </div>

                <!-- Copiar para outra divisao -->
                @if(!$overrides->isEmpty())
                <div class="bg-white rounded-lg shadow mt-6 p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Copiar para outra divisao</h3>

                    <form action="{{ route('admin.divisoes.permissions.copy', $divisao) }}" method="POST" class="flex items-end gap-4">
                        @csrf
                        <div class="flex-1">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Divisao destino</label>
                            <select name="target_divisao_id" required class="w-full border-gray-300 rounded-md shadow-sm">
                                <option value="">Seleccione...</option>
                                @foreach(\App\Models\DivisaoAdministrativa::ativo()->where('id', '!=', $divisao->id)->orderBy('nome')->get() as $d)
                                <option value="{{ $d->id }}">{{ $d->nome }} ({{ $d->tipo }})</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="flex items-center">
                            <input type="checkbox" name="overwrite" id="overwrite" value="1" class="rounded border-gray-300 text-blue-600">
                            <label for="overwrite" class="ml-2 text-sm text-gray-700">Substituir existentes</label>
                        </div>
                        <button type="submit" class="bg-purple-600 hover:bg-purple-700 text-white py-2 px-4 rounded-md">
                            <i class="fas fa-copy mr-1"></i> Copiar
                        </button>
                    </form>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
