@extends('layouts.app')

@section('title', $divisao->nome)

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex justify-between items-start mb-6">
            <div>
                <div class="flex items-center gap-3">
                    <div class="h-12 w-12 rounded-lg flex items-center justify-center text-white font-bold
                        {{ $divisao->tipo == 'provincia' ? 'bg-purple-500' : ($divisao->tipo == 'distrito' ? 'bg-blue-500' : 'bg-green-500') }}">
                        <i class="fas {{ $divisao->tipo == 'provincia' ? 'fa-map' : 'fa-map-marker-alt' }} text-xl"></i>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900">{{ $divisao->nome }}</h1>
                        <p class="text-sm text-gray-600">{{ $divisao->codigo }} - {{ ucfirst($divisao->tipo) }}</p>
                    </div>
                </div>
            </div>
            <div class="flex gap-2">
                <a href="{{ route('admin.admin.divisoes-admin.edit', $divisao) }}" class="bg-yellow-500 hover:bg-yellow-600 text-white py-2 px-4 rounded-lg">
                    <i class="fas fa-edit mr-1"></i> Editar
                </a>
                <a href="{{ route('admin.admin.divisoes-admin.index') }}" class="bg-gray-600 hover:bg-gray-700 text-white py-2 px-4 rounded-lg">
                    <i class="fas fa-arrow-left mr-1"></i> Voltar
                </a>
            </div>
        </div>

        @if(session('success'))
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
            {{ session('success') }}
        </div>
        @endif

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Coluna Principal -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Informacoes Gerais -->
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informacoes Gerais</h3>

                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Nome</dt>
                            <dd class="text-sm text-gray-900">{{ $divisao->nome }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Codigo</dt>
                            <dd class="text-sm text-gray-900">{{ $divisao->codigo }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Tipo</dt>
                            <dd>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium capitalize
                                    {{ $divisao->tipo == 'provincia' ? 'bg-purple-100 text-purple-800' : ($divisao->tipo == 'distrito' ? 'bg-blue-100 text-blue-800' : 'bg-green-100 text-green-800') }}">
                                    {{ $divisao->tipo }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status</dt>
                            <dd>
                                @if($divisao->ativo)
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-green-100 text-green-800">
                                    <i class="fas fa-check-circle mr-1"></i> Activo
                                </span>
                                @else
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-red-100 text-red-800">
                                    <i class="fas fa-times-circle mr-1"></i> Inactivo
                                </span>
                                @endif
                            </dd>
                        </div>
                        @if($divisao->parent)
                        <div class="md:col-span-2">
                            <dt class="text-sm font-medium text-gray-500">Pertence a</dt>
                            <dd class="text-sm text-gray-900">
                                <a href="{{ route('admin.admin.divisoes-admin.show', $divisao->parent) }}" class="text-blue-600 hover:underline">
                                    {{ $divisao->parent->nome }} ({{ $divisao->parent->tipo }})
                                </a>
                            </dd>
                        </div>
                        @endif
                        @if($divisao->descricao)
                        <div class="md:col-span-2">
                            <dt class="text-sm font-medium text-gray-500">Descricao</dt>
                            <dd class="text-sm text-gray-900">{{ $divisao->descricao }}</dd>
                        </div>
                        @endif
                    </dl>
                </div>

                <!-- Informacoes Geograficas -->
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informacoes Geograficas</h3>

                    <dl class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Area</dt>
                            <dd class="text-sm text-gray-900">
                                {{ $divisao->area_km2 ? number_format($divisao->area_km2, 2, ',', '.') . ' km2' : '-' }}
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Populacao</dt>
                            <dd class="text-sm text-gray-900">
                                {{ $divisao->populacao ? number_format($divisao->populacao, 0, ',', '.') : '-' }}
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Latitude</dt>
                            <dd class="text-sm text-gray-900">{{ $divisao->latitude ?? '-' }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Longitude</dt>
                            <dd class="text-sm text-gray-900">{{ $divisao->longitude ?? '-' }}</dd>
                        </div>
                    </dl>
                </div>

                <!-- Subdivisoes -->
                @if($divisao->children->count() > 0)
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">
                        Subdivisoes ({{ $divisao->children->count() }})
                    </h3>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
                        @foreach($divisao->children as $child)
                        <a href="{{ route('admin.admin.divisoes-admin.show', $child) }}"
                           class="flex items-center p-3 border rounded-lg hover:bg-gray-50 transition">
                            <div class="h-8 w-8 rounded flex items-center justify-center text-white text-xs
                                {{ $child->tipo == 'distrito' ? 'bg-blue-500' : 'bg-green-500' }}">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <div class="ml-3">
                                <div class="text-sm font-medium text-gray-900">{{ $child->nome }}</div>
                                <div class="text-xs text-gray-500">{{ $child->codigo }}</div>
                            </div>
                        </a>
                        @endforeach
                    </div>
                </div>
                @endif

                <!-- Utilizadores -->
                @if($divisao->users->count() > 0)
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">
                        Utilizadores Atribuidos ({{ $divisao->users->count() }})
                    </h3>

                    <div class="space-y-3">
                        @foreach($divisao->users as $user)
                        <div class="flex items-center justify-between p-3 border rounded-lg">
                            <div class="flex items-center">
                                <div class="h-10 w-10 rounded-full bg-blue-500 flex items-center justify-center text-white font-medium">
                                    {{ strtoupper(substr($user->name, 0, 2)) }}
                                </div>
                                <div class="ml-3">
                                    <div class="text-sm font-medium text-gray-900">{{ $user->name }}</div>
                                    <div class="text-xs text-gray-500">{{ $user->email }}</div>
                                </div>
                            </div>
                            <div class="text-sm text-gray-500">
                                @foreach($user->roles as $role)
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-800">
                                    {{ $role->name }}
                                </span>
                                @endforeach
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>

            <!-- Coluna Lateral -->
            <div class="space-y-6">
                <!-- Estatisticas -->
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Estatisticas</h3>

                    <div class="space-y-4">
                        <div class="flex justify-between items-center p-3 bg-purple-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-sitemap text-purple-500 mr-3"></i>
                                <span class="text-sm text-gray-700">Subdivisoes</span>
                            </div>
                            <span class="text-lg font-bold text-purple-600">{{ $divisao->children->count() }}</span>
                        </div>

                        <div class="flex justify-between items-center p-3 bg-blue-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-users text-blue-500 mr-3"></i>
                                <span class="text-sm text-gray-700">Utilizadores</span>
                            </div>
                            <span class="text-lg font-bold text-blue-600">{{ $divisao->users->count() }}</span>
                        </div>

                        <div class="flex justify-between items-center p-3 bg-green-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-water text-green-500 mr-3"></i>
                                <span class="text-sm text-gray-700">Barragens</span>
                            </div>
                            <span class="text-lg font-bold text-green-600">{{ $divisao->barragens->count() }}</span>
                        </div>

                        <div class="flex justify-between items-center p-3 bg-orange-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-broadcast-tower text-orange-500 mr-3"></i>
                                <span class="text-sm text-gray-700">Estacoes</span>
                            </div>
                            <span class="text-lg font-bold text-orange-600">{{ $divisao->estacoes->count() }}</span>
                        </div>
                    </div>
                </div>

                <!-- Hierarquia -->
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Hierarquia</h3>

                    <div class="space-y-2">
                        @php
                            $ancestors = [];
                            $current = $divisao->parent;
                            while ($current) {
                                array_unshift($ancestors, $current);
                                $current = $current->parent;
                            }
                        @endphp

                        @foreach($ancestors as $index => $ancestor)
                        <div class="flex items-center" style="padding-left: {{ $index * 16 }}px">
                            <i class="fas fa-chevron-right text-gray-400 mr-2 text-xs"></i>
                            <a href="{{ route('admin.admin.divisoes-admin.show', $ancestor) }}" class="text-sm text-blue-600 hover:underline">
                                {{ $ancestor->nome }}
                            </a>
                        </div>
                        @endforeach

                        <div class="flex items-center font-semibold" style="padding-left: {{ count($ancestors) * 16 }}px">
                            <i class="fas fa-map-marker-alt text-purple-500 mr-2"></i>
                            <span class="text-sm text-gray-900">{{ $divisao->nome }}</span>
                        </div>

                        @if($divisao->children->count() > 0)
                        <div class="text-xs text-gray-500 mt-2" style="padding-left: {{ (count($ancestors) + 1) * 16 }}px">
                            + {{ $divisao->children->count() }} subdivisoes
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Accoes Rapidas -->
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Accoes</h3>

                    <div class="space-y-2">
                        <a href="{{ route('admin.admin.divisoes-admin.create') }}?parent_id={{ $divisao->id }}"
                           class="flex items-center p-2 text-sm text-gray-700 hover:bg-gray-50 rounded">
                            <i class="fas fa-plus text-green-500 mr-3 w-4"></i>
                            Adicionar Subdivisao
                        </a>
                        <a href="{{ route('admin.admin.divisoes-admin.edit', $divisao) }}"
                           class="flex items-center p-2 text-sm text-gray-700 hover:bg-gray-50 rounded">
                            <i class="fas fa-edit text-yellow-500 mr-3 w-4"></i>
                            Editar Divisao
                        </a>
                        @if($divisao->children->count() == 0 && $divisao->users->count() == 0 && $divisao->barragens->count() == 0)
                        <form action="{{ route('admin.admin.divisoes-admin.destroy', $divisao) }}" method="POST"
                              onsubmit="return confirm('Tem certeza?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="w-full flex items-center p-2 text-sm text-red-600 hover:bg-red-50 rounded">
                                <i class="fas fa-trash mr-3 w-4"></i>
                                Eliminar Divisao
                            </button>
                        </form>
                        @endif
                    </div>
                </div>

                <!-- Timestamps -->
                <div class="bg-gray-50 rounded-lg p-4 text-xs text-gray-500">
                    <div class="flex justify-between mb-1">
                        <span>Criado:</span>
                        <span>{{ $divisao->created_at->format('d/m/Y H:i') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Actualizado:</span>
                        <span>{{ $divisao->updated_at->format('d/m/Y H:i') }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
