@extends('layouts.app')

@section('title', 'Detalhes do Perfil')

@section('content')
<div class="py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">{{ $role->name }}</h1>
                <p class="text-sm text-gray-600 mt-1">Detalhes do perfil e suas permissões</p>
            </div>
            <div class="flex gap-2">
                @if($role->name !== 'Administrador')
                <a href="{{ route('admin.roles.edit', $role) }}" class="bg-yellow-600 hover:bg-yellow-700 text-white py-2 px-4 rounded-md">
                    <i class="fas fa-edit mr-1"></i> Editar
                </a>
                @endif
                <a href="{{ route('admin.roles.index') }}" class="text-gray-600 hover:text-gray-900 py-2 px-4">
                    <i class="fas fa-arrow-left mr-1"></i> Voltar
                </a>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Informações -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informações</h3>

                    <dl class="space-y-3">
                        <div>
                            <dt class="text-sm text-gray-500">Nome</dt>
                            <dd class="text-gray-900 font-medium">{{ $role->name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm text-gray-500">Permissões</dt>
                            <dd class="text-gray-900">
                                @if($role->name === 'Administrador')
                                <span class="text-red-600">Todas (Admin)</span>
                                @else
                                {{ $role->permissions->count() }} permissões
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm text-gray-500">Utilizadores</dt>
                            <dd class="text-gray-900">{{ $role->users()->count() }} utilizador(es)</dd>
                        </div>
                        <div>
                            <dt class="text-sm text-gray-500">Criado em</dt>
                            <dd class="text-gray-900">{{ $role->created_at?->format('d/m/Y H:i') ?? 'N/A' }}</dd>
                        </div>
                    </dl>

                    @if($role->name === 'Administrador')
                    <div class="mt-4 p-3 bg-red-50 border border-red-200 rounded-lg">
                        <p class="text-sm text-red-700">
                            <i class="fas fa-shield-alt mr-1"></i>
                            Perfil de sistema protegido
                        </p>
                    </div>
                    @endif
                </div>

                <!-- Utilizadores com este Perfil -->
                <div class="bg-white rounded-lg shadow p-6 mt-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Utilizadores</h3>

                    @if($role->users()->count() > 0)
                    <div class="space-y-2 max-h-60 overflow-y-auto">
                        @foreach($role->users()->take(10)->get() as $user)
                        <a href="{{ route('admin.usuarios.show', $user) }}"
                           class="flex items-center p-2 rounded-lg hover:bg-gray-50">
                            <div class="flex-shrink-0 h-8 w-8">
                                <div class="h-8 w-8 rounded-full bg-blue-500 flex items-center justify-center text-white text-sm font-bold">
                                    {{ strtoupper(substr($user->name, 0, 1)) }}
                                </div>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-gray-900">{{ $user->name }}</p>
                                <p class="text-xs text-gray-500">{{ $user->email }}</p>
                            </div>
                        </a>
                        @endforeach
                        @if($role->users()->count() > 10)
                        <p class="text-sm text-gray-500 text-center pt-2">
                            +{{ $role->users()->count() - 10 }} mais utilizadores
                        </p>
                        @endif
                    </div>
                    @else
                    <p class="text-gray-400 text-sm italic">Nenhum utilizador com este perfil</p>
                    @endif
                </div>
            </div>

            <!-- Permissões -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Permissões Atribuídas</h3>

                    @if($role->name === 'Administrador')
                    <div class="p-4 bg-red-50 border border-red-200 rounded-lg mb-4">
                        <p class="text-red-700">
                            <i class="fas fa-crown mr-2"></i>
                            O perfil Administrador tem acesso total ao sistema.
                        </p>
                    </div>
                    @endif

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @foreach($permissoesPorCategoria as $categoria => $perms)
                        <div class="border rounded-lg p-4">
                            <h4 class="font-medium text-gray-700 capitalize mb-3">
                                <i class="fas fa-folder mr-2 text-blue-500"></i>
                                {{ $categoria }}
                            </h4>
                            <div class="space-y-1">
                                @foreach($perms as $permission)
                                <div class="flex items-center text-sm">
                                    @if($role->name === 'Administrador' || $role->hasPermissionTo($permission->name))
                                    <i class="fas fa-check-circle text-green-500 mr-2"></i>
                                    <span class="text-gray-700">{{ $permission->name }}</span>
                                    @else
                                    <i class="fas fa-times-circle text-gray-300 mr-2"></i>
                                    <span class="text-gray-400">{{ $permission->name }}</span>
                                    @endif
                                </div>
                                @endforeach
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
