@extends('layouts.app')

@section('title', 'Novo Utilizador')

@section('content')
<div class="py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Novo Utilizador</h1>
                <p class="text-sm text-gray-600 mt-1">Criar novo utilizador com roles e divisoes</p>
            </div>
            <a href="{{ route('admin.usuarios.index') }}" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-arrow-left mr-1"></i> Voltar
            </a>
        </div>

        <form action="{{ route('admin.usuarios.store') }}" method="POST" class="space-y-6">
            @csrf

            <!-- Dados Basicos -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Dados Basicos</h3>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Nome *</label>
                        <input type="text" name="name" value="{{ old('name') }}" required
                               class="w-full border-gray-300 rounded-md shadow-sm @error('name') border-red-500 @enderror">
                        @error('name')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Email *</label>
                        <input type="email" name="email" value="{{ old('email') }}" required
                               class="w-full border-gray-300 rounded-md shadow-sm @error('email') border-red-500 @enderror">
                        @error('email')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Password *</label>
                        <input type="password" name="password" required
                               class="w-full border-gray-300 rounded-md shadow-sm @error('password') border-red-500 @enderror">
                        @error('password')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Telefone</label>
                        <input type="text" name="telefone" value="{{ old('telefone') }}" placeholder="+258 84 xxx xxxx"
                               class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Cargo</label>
                        <input type="text" name="cargo" value="{{ old('cargo') }}" placeholder="Ex: Tecnico de Recursos Hidricos"
                               class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Departamento</label>
                        <input type="text" name="departamento" value="{{ old('departamento') }}"
                               class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                </div>
            </div>

            <!-- Roles e Permissoes -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Roles e Permissoes</h3>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Roles *</label>
                    <div class="grid grid-cols-2 md:grid-cols-3 gap-3">
                        @foreach($roles as $role)
                        <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50
                            @if($role->name == 'Administrador') border-red-200 hover:bg-red-50
                            @elseif($role->name == 'Tecnico Senior') border-purple-200 hover:bg-purple-50
                            @endif">
                            <input type="checkbox" name="roles[]" value="{{ $role->id }}"
                                   class="rounded border-gray-300 text-blue-600"
                                   {{ in_array($role->id, old('roles', [])) ? 'checked' : '' }}>
                            <span class="ml-2 text-sm">{{ $role->name }}</span>
                        </label>
                        @endforeach
                    </div>
                    @error('roles')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex items-center">
                    <input type="checkbox" name="acesso_global" id="acesso_global" value="1"
                           class="rounded border-gray-300 text-yellow-600"
                           {{ old('acesso_global') ? 'checked' : '' }}>
                    <label for="acesso_global" class="ml-2 text-sm text-gray-700">
                        <span class="font-medium">Acesso Global</span>
                        <span class="text-gray-500">- Pode ver e gerir todas as divisoes</span>
                    </label>
                </div>
            </div>

            <!-- Divisoes -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Divisoes de Acesso</h3>
                <p class="text-sm text-gray-600 mb-4">Selecione as divisoes que este utilizador pode acessar. Se "Acesso Global" estiver activo, estas opcoes serao ignoradas.</p>

                @foreach($divisoes as $tipo => $divs)
                <div class="mb-4">
                    <h4 class="font-medium text-gray-700 mb-2 capitalize">{{ $tipo }}s</h4>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-2">
                        @foreach($divs as $divisao)
                        <label class="flex items-center p-2 border rounded cursor-pointer hover:bg-blue-50">
                            <input type="checkbox" name="divisoes[]" value="{{ $divisao->id }}"
                                   class="rounded border-gray-300 text-blue-600"
                                   {{ in_array($divisao->id, old('divisoes', [])) ? 'checked' : '' }}>
                            <span class="ml-2 text-sm">{{ $divisao->nome }}</span>
                        </label>
                        @endforeach
                    </div>
                </div>
                @endforeach

                <div class="mt-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Divisao Principal</label>
                    <select name="divisao_principal_id" class="w-full border-gray-300 rounded-md shadow-sm">
                        <option value="">Selecione...</option>
                        @foreach($divisoes as $tipo => $divs)
                        <optgroup label="{{ ucfirst($tipo) }}s">
                            @foreach($divs as $divisao)
                            <option value="{{ $divisao->id }}">{{ $divisao->nome }}</option>
                            @endforeach
                        </optgroup>
                        @endforeach
                    </select>
                </div>
            </div>

            <!-- Status -->
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center">
                    <input type="checkbox" name="ativo" id="ativo" value="1"
                           class="rounded border-gray-300 text-green-600"
                           {{ old('ativo', true) ? 'checked' : '' }}>
                    <label for="ativo" class="ml-2 text-sm text-gray-700">
                        <span class="font-medium">Utilizador Activo</span>
                        <span class="text-gray-500">- Pode fazer login no sistema</span>
                    </label>
                </div>
            </div>

            <!-- Botoes -->
            <div class="flex justify-end gap-3">
                <a href="{{ route('admin.usuarios.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 py-2 px-4 rounded-md">
                    Cancelar
                </a>
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-6 rounded-md">
                    <i class="fas fa-save mr-1"></i> Criar Utilizador
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
